\version "2.24.4"
%% arp.gism7.2noteseq.gap.ly
%% Beginn: 2026-01-14
%% letzte Änderung: 2026-01-14
#(define RH rightHandFinger)

%% \arpBarre
%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})
%% \arpBarre Ende
%% ************************************

arpGisMinorSevenTwoNoteSeqGap = \relative c'' {
  \time 3/4
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \tuplet 3/2 { < b-4-\1 >8^\markup "IV."\upbow \arpBarre #-14 < gis-1 >\downbow r }
  \tuplet 3/2 { gis\upbow < fis-3-\2 >\downbow r }
  \tuplet 3/2 { fis\upbow dis\downbow r }
  |
                                %2
  \tuplet 3/2 { dis\upbow < b-\3 >\downbow r }
  \tuplet 3/2 { b\upbow < gis-4-\4 >\downbow r }
  \tuplet 3/2 { gis\upbow fis\downbow r }
  |
                                %3
  \tuplet 3/2 { fis\upbow < dis-3-\5 >\downbow r }
  \tuplet 3/2 { dis\upbow < b-4-\6 >\downbow r }
  \tuplet 3/2 { b\upbow gis\downbow r }
  |

                                %4
  \tuplet 3/2 { gis\upbow b\downbow r }
  \tuplet 3/2 { b\upbow < dis-2 >\downbow r }
  \tuplet 3/2 { dis\upbow fis\downbow r }
  |
                                %5
  \tuplet 3/2 { fis\upbow < gis-3 >\downbow r }
  \tuplet 3/2 { gis\upbow b\downbow r }
  \tuplet 3/2 { b\upbow dis\downbow r }
  |
                                %6
  \tuplet 3/2 { dis\upbow < fis-3 >\downbow r }
  \tuplet 3/2 { fis\upbow gis\downbow r }
  \tuplet 3/2 { gis\upbow b\downbow r }
  |
  \bar "|."
}

\book {
  \score {
    \arpGisMinorSevenTwoNoteSeqGap
  }
}
