\version "2.24.4"
%% arp.fism7.aeolian-scale.ly
%% Beginn: 2026-01-13
%% letzte Änderung: 2026-01-13
#(define RH rightHandFinger)

%% \arpBarre
%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})
%% \arpBarre Ende
%% ************************************

arpFisMSevenAeolianScale = \relative c'' {
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \time 4/4
  < a-4-\1 >8\downbow^\markup "II." < fis-1 >\upbow
  < e-3-\2 >\downbow \arpBarre #-2 < cis-1 >\upbow
  < a-\3 >\downbow b\upbow
  e\downbow fis\upbow
  |
                                %2
  \time 5/4
  \tuplet 3/2 { a\downbow gis\upbow\upbow fis\downbow }
  \tuplet 3/2 { e d\downbow cis\upbow }
  \tuplet 3/2 { b\downbow a\upbow b\downbow }
  \tuplet 3/2 { cis\upbow d\downbow e\upbow }
  \tuplet 3/2 { fis\downbow gis\upbow a\downbow }
  |
  \break
                                %3
  \time 4/4
  fis\upbow < e-3-\2 >\downbow
  \arpBarre #-2 < cis-1 >\upbow a\downbow
  < fis-3-\4 >\upbow a\downbow
  cis\upbow e\downbow
  |
                                %4
  \time 5/4
  \tuplet 3/2 { fis\upbow e\downbow d\upbow }
  \tuplet 3/2 { cis\downbow b\upbow a\downbow }
  \tuplet 3/2 { < gis-4-\4 >\upbow < fis-2 >\downbow gis\upbow }
  \tuplet 3/2 { a\downbow b\upbow cis\downbow }
  \tuplet 3/2 { d\upbow e\downbow fis\upbow }
  |
  \break

                                %5
  \time 4/4
  e\downbow \arpBarre #-5 < cis-1 >
  a fis
  e fis
  a cis
  |
                                %6
  \time 5/4
  \tuplet 3/2 { e\downbow d cis }
  \tuplet 3/2 { b a < gis-4-\4 > }
  \tuplet 3/2 { < fis-2 > e fis }
  \tuplet 3/2 { gis a b }
  \tuplet 3/2 { cis d e }
  |
  \break
                                %7
  \time 4/4
  cis\upbow a
  fis e
  < cis-3-\5 > e
  fis a
  |
                                %8
  \time 5/4
  \tuplet 3/2 { cis\upbow b a }
  \tuplet 3/2 { gis fis e }
  \tuplet 3/2 { < d-\4-\5 > cis d }
  \tuplet 3/2 { e fis gis }
  \tuplet 3/2 { a b cis }
  |
  \break

                                %9
  \time 4/4
  a\downbow fis
  e cis
  < a-4-\6 > cis
  e fis
  |
                                %10
  \time 5/4
  \tuplet 3/2 { a\downbow gis fis }
  \tuplet 3/2 { e d cis }
  \tuplet 3/2 { < b-1 > a b }
  \tuplet 3/2 { cis d e }
  \tuplet 3/2 { fis gis a }
  |
  \break
                                %11
  \time 4/4
  fis\upbow e
  cis a
  < fis-1 > a
  cis e
  |
                                %12
  \time 5/4
  \tuplet 3/2 { fis\upbow e d }
  \tuplet 3/2 { cis b a }
  \tuplet 3/2 { < gis-2 > fis gis }
  \tuplet 3/2 { a b cis }
  \tuplet 3/2 { d e fis }
  |
  \break

                                %13
  \time 4/4
  < fis,-1-\6 >\downbow < a-4 >
  < cis-2-\5 > < e-1-\4 >
  < fis-3 > e
  cis a
  |
                                %14
  \time 5/4
  \tuplet 3/2 { fis\downbow < gis-3 > < a-4 > }
  \tuplet 3/2 { < b-1-\5 > < cis-3 > < d-4 > }
  \tuplet 3/2 { < e-1-\4 > < fis-3 > e }
  \tuplet 3/2 { d cis b }
  \tuplet 3/2 { a gis fis }
  |
  \break
                                %15
  \time 4/4
  a\upbow < cis-2 >
  e < fis-3 >
  < a-1-\3 > fis
  e cis
  |
                                %16
  \time 5/4
  \tuplet 3/2 { a\upbow < b-1 > < cis-3 > }
  \tuplet 3/2 { < d-4 > < e-1 > < fis-2 > }
  \tuplet 3/2 { < gis-4 > < a-1 > gis }
  \tuplet 3/2 { fis e d }
  \tuplet 3/2 { cis b a }
  |
  \break

                                %17
  \time 4/4
  < cis-2-\5 >\downbow \arpBarre #5 < e-1-\4 >
  < fis-3 > < a-\3 >
  < cis-\2 > a
  fis e
  |
                                %18
  \time 5/4
  \tuplet 3/2 { < cis-3-\5 >\downbow < d-4 > < e-1-\4 > }
  \tuplet 3/2 { < fis-2 > < gis-4 > < a-1 > }
  \tuplet 3/2 { < b-3 > cis b }
  \tuplet 3/2 { a gis fis }
  \tuplet 3/2 { e d cis }
  |
                                %19
  \time 4/4
  < e-1-\4 >\upbow < fis-3 >
  \arpBarre #5 < a-1-\3 > < cis-\2 >
  < e-3 > cis8
  a fis
  |
                                %20
  \time 5/4
  \tuplet 3/2 { < e-1-\4 >\upbow < fis-2 > < gis-4 > }
  \tuplet 3/2 { < a-1 > < b-3 > < cis-1 > }
  \tuplet 3/2 { < d-2 > < e-4 > d }
  \tuplet 3/2 { cis b a }
  \tuplet 3/2 { gis fis e }
  |

                                %21
  \time 4/4
  < fis-3 >\downbow a
  cis < e-3 >
  < fis-1-\1 > e
  cis a
  |
                                %22
  \time 5/4
  \tuplet 3/2 { < fis-2-\4 >\downbow < gis-4 > < a-1-\3 > }
  \tuplet 3/2 { < b-3 > < cis-1-\2 > < d-2 > }
  \tuplet 3/2 { < e-4 > < fis-1-\1 > e }
  \tuplet 3/2 { d cis b }
  \tuplet 3/2 { a gis fis }
  |
                                %23
  \time 4/4
  \arpBarre #5 < a-1-\2 >\upbow < cis-\2 >
  < e-3 > < fis-\1 >
  < a-4 > fis
  e  cis8
  |
                                %24
  \time 5/4
  \tuplet 3/2 { < a-1 >\upbow < b-3 > < cis-1 > }
  \tuplet 3/2 { < d-2 > < e-4 > < fis-1-\1 > }
  \tuplet 3/2 { < gis-3 > < a-4 > gis }
  \tuplet 3/2 { fis e d }
  \tuplet 3/2 { cis b a }
  |
  \bar "|."
}

arpFisMSevenAeolianScaleOneSeq = \relative c'' {
  \time 4/4
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \time 4/4
  < a-4-\1 >8\downbow^\markup "II." < fis-1 >\upbow
  < e-3-\2 >\downbow \arpBarre #-2 < cis-1 >\upbow
  < a-\3 >\downbow b\upbow
  e\downbow fis\upbow
  |
                                %2
  r1
  |
                                %3
  \time 5/4
  \tuplet 3/2 { a8\downbow gis\upbow\upbow fis\downbow }
  \tuplet 3/2 { e d\downbow cis\upbow }
  \tuplet 3/2 { b\downbow a\upbow b\downbow }
  \tuplet 3/2 { cis\upbow d\downbow e\upbow }
  \tuplet 3/2 { fis\downbow gis\upbow a\downbow }
  |
                                %4
  \time 4/4
  r1
  |
                                %5
  fis8\upbow < e-3-\2 >\downbow
  \arpBarre #-2 < cis-1 >\upbow a\downbow
  < fis-3-\4 >\upbow a\downbow
  cis\upbow e\downbow
  |
                                %6
  r1^\markup "etc."
  |
  \bar ":"
}

arpFisMSevenAeolianScaleTwoSeq = \relative c'' {
  \time 3/4
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \time 4/4
  < a-4-\1 >8\downbow^\markup "II." < fis-1 >\upbow
  < e-3-\2 >\downbow \arpBarre #-2 < cis-1 >\upbow
  < a-\3 >\downbow b\upbow
  e\downbow fis\upbow
  |
                                %2
  \time 5/4
  \tuplet 3/2 { a\downbow gis\upbow\upbow fis\downbow }
  \tuplet 3/2 { e d\downbow cis\upbow }
  \tuplet 3/2 { b\downbow a\upbow b\downbow }
  \tuplet 3/2 { cis\upbow d\downbow e\upbow }
  \tuplet 3/2 { fis\downbow gis\upbow a\downbow }
  |
                                %3
  \time 4/4
  r1
  |
                                %4
  fis8\upbow < e-3-\2 >\downbow
  \arpBarre #-2 < cis-1 >\upbow a\downbow
  < fis-3-\4 >\upbow a\downbow
  cis\upbow e\downbow
  |
                                %5
  \time 5/4
  \tuplet 3/2 { fis\upbow e\downbow d\upbow }
  \tuplet 3/2 { cis\downbow b\upbow a\downbow }
  \tuplet 3/2 { < gis-4-\4 >\upbow < fis-2 >\downbow gis\upbow }
  \tuplet 3/2 { a\downbow b\upbow cis\downbow }
  \tuplet 3/2 { d\upbow e\downbow fis\upbow }
  |
                                %6
  \time 4/4
  r1^\markup "etc."
  |
  \bar ":"
}

\book {
  \score {
    \arpFisMSevenAeolianScale
  }
}

#(define output-suffix "1")
\book {
  \score {
    \arpFisMSevenAeolianScaleOneSeq
  }
}

#(define output-suffix "2")
\book {
  \score {
    \arpFisMSevenAeolianScaleTwoSeq
  }
}
