\version "2.24.4"
%% arp.fism7.2noteseq.ly
%% Beginn: 2026-01-16
%% letzte Änderung: 2026-01-16
#(define RH rightHandFinger)

%% \arpBarre
%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})
%% \arpBarre Ende
%% ************************************

arpFisMinorSevenTwoNoteSeq = \relative c'' {
  \time 4/4
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \tuplet 3/2 { < a-4-\1 >8^\markup "II."\upbow \arpBarre #-14 < e-1 >\downbow e\upbow }
  \tuplet 3/2 { < e-3-\2 >\downbow e\upbow cis\downbow }
  \tuplet 3/2 { cis\upbow < a-\3 >\downbow a\upbow }
  \tuplet 3/2 {  < e-4-\4 >\downbow e\upbow e\downbow }
  |
                                %2
  \tuplet 3/2 { e\upbow < cis-3-\5 >\downbow cis\upbow }
  \tuplet 3/2 { < a-4-\6 >\downbow a\upbow e\downbow }
  \tuplet 3/2 { e\upbow a\downbow a\upbow }
  \tuplet 3/2 {  < cis-2 >\downbow cis\upbow e\downbow }
  |
                                %3
  \tuplet 3/2 { e\upbow < e-3 >\downbow e\upbow }
  \tuplet 3/2 {  a\downbow a\upbow cis\downbow }
  \tuplet 3/2 { cis\upbow < e-3 >\downbow e\upbow }
  \tuplet 3/2 {  e\downbow e\upbow a\downbow }
  |
  \bar "|."
}

\book {
  \score {
    \arpFisMinorSevenTwoNoteSeq
  }
}
