\version "2.24.4"
%% arp.cism7.IX.phrygian-scale.ly
%% Beginn: 2026-01-15
%% letzte Änderung: 2026-01-15
#(define RH rightHandFinger)

%% \arpBarre
%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})
%% \arpBarre Ende
%% ************************************

arpCisMSevenIXPhrygianScale = \relative c'' {
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \time 4/4
  < e-4-\1 >8\upbow^\markup "IX." < cis-1 >\downbow
  < b-3-\2 >\upbow \arpBarre #-2 < gis-1 >\downbow
  < e-\3 >\upbow fis\downbow
  b\upbow cis\downbow
  |
                                %2
  \time 5/4
  \tuplet 3/2 { e\upbow < d-2 >\downbow\downbow cis\upbow }
  \tuplet 3/2 { b < a-2 >\upbow gis\downbow }
  \tuplet 3/2 { fis\upbow e\downbow fis\upbow }
  \tuplet 3/2 { gis\downbow a\upbow b\downbow }
  \tuplet 3/2 { cis\upbow d\downbow e\upbow }
  |
  \break
                                %3
  \time 4/4
  cis\downbow < b-3-\2 >\upbow
  \arpBarre #-2 < gis-1 >\downbow e\upbow
  < cis-3-\4 >\downbow e\upbow
  gis\downbow b\upbow
  |
                                %4
  \time 5/4
  \tuplet 3/2 { cis\downbow b\upbow a\downbow }
  \tuplet 3/2 { gis\upbow fis\downbow e\upbow }
  \tuplet 3/2 { < d-4-\4 >\downbow < cis-3 >\upbow d\downbow }
  \tuplet 3/2 { e\upbow fis\downbow gis\upbow }
  \tuplet 3/2 { a\downbow b\upbow cis\downbow }
  |
  \break

                                %5
  \time 4/4
  b\upbow \arpBarre #-5 < gis-1 >
  e cis
  b cis
  e gis
  |
                                %6
  \time 5/4
  \tuplet 3/2 { b\upbow a gis }
  \tuplet 3/2 { fis e < d-4-\4 > }
  \tuplet 3/2 { < cis-3 > b cis }
  \tuplet 3/2 { d e fis }
  \tuplet 3/2 { gis a b }
  |
  \break
                                %7
  \time 4/4
  gis\downbow e
  cis b
  < gis-3-\5 > b
  cis e
  |
                                %8
  \time 5/4
  \tuplet 3/2 { gis\downbow fis e }
  \tuplet 3/2 { d cis b }
  \tuplet 3/2 { < a-\4-\5 > gis a }
  \tuplet 3/2 { b cis d }
  \tuplet 3/2 { e fis gis }
  |
  \break

                                %9
  \time 4/4
  e\upbow cis
  b gis
  < e-4-\6 > gis
  b cis
  |
                                %10
  \time 5/4
  \tuplet 3/2 { e\upbow d cis }
  \tuplet 3/2 { b a gis }
  \tuplet 3/2 { < fis-1 > e fis }
  \tuplet 3/2 { gis a b }
  \tuplet 3/2 { cis d e }
  |
  \break
                                %11
  \time 4/4
  cis\downbow b
  gis e
  < cis-1 > e
  gis b
  |
                                %12
  \time 5/4
  \tuplet 3/2 { cis\downbow b a }
  \tuplet 3/2 { gis fis e }
  \tuplet 3/2 { < d-2 > cis d }
  \tuplet 3/2 { e fis gis }
  \tuplet 3/2 { a b cis }
  |
  \break

                                %13
  \time 4/4
  < cis,-1-\6 >\upbow < e-4 >
  < gis-2-\5 > < b-1-\4 >
  < cis-3 > b
  gis e
  |
                                %14
  \time 5/4
  \tuplet 3/2 { cis\upbow < d-3 > < e-4 > }
  \tuplet 3/2 { < fis-1-\5 > < gis-3 > < a-4 > }
  \tuplet 3/2 { < b-1-\4 > < cis-3 > b }
  \tuplet 3/2 { a gis fis }
  \tuplet 3/2 { e d cis }
  |
  \break
                                %15
  \time 4/4
  e\downbow < gis-2 >
  b < cis-3 >
  < e-1-\3 > cis
  b gis
  |
                                %16
  \time 5/4
  \tuplet 3/2 { e\downbow < fis-1 > < gis-3 > }
  \tuplet 3/2 { < a-4 > < b-1 > < cis-2 > }
  \tuplet 3/2 { < d-4 > < e-1 > d }
  \tuplet 3/2 { cis b a }
  \tuplet 3/2 { gis fis e }
  |
  \break

                                %17
  \time 4/4
  < gis-2-\5 >\upbow \arpBarre #5 < b-1-\4 >
  < cis-3 > < e-\3 >
  < gis-\2 > e
  cis b
  |
                                %18
  \time 5/4
  \tuplet 3/2 { < gis-3-\5 >\upbow < a-4 > < b-1-\4 > }
  \tuplet 3/2 { < cis-2 > < d-4 > < e-1 > }
  \tuplet 3/2 { < fis-3 > gis fis }
  \tuplet 3/2 { e d cis }
  \tuplet 3/2 { b a gis }
  |
                                %19
  \time 4/4
  < b-1-\4 >\downbow < cis-3 >
  \arpBarre #5 < e-1-\3 > < gis-\2 >
  < b-3 > gis8
  e cis
  |
                                %20
  \time 5/4
  \tuplet 3/2 { < b-1-\4 >\downbow < cis-2 > < d-4 > }
  \tuplet 3/2 { < e-1 > < fis-3 > < gis-1 > }
  \tuplet 3/2 { < a-2 > < b-4 > a }
  \tuplet 3/2 { gis fis e }
  \tuplet 3/2 { d cis b }
  |

                                %21
  \time 4/4
  < cis-3 >\upbow e
  gis < b-3 >
  < cis-1-\1 > b
  gis e
  |
                                %22
  \time 5/4
  \tuplet 3/2 { < cis-2-\4 >\upbow < d-4 > < e-1-\3 > }
  \tuplet 3/2 { < fis-3 > < gis-1-\2 > < a-2 > }
  \tuplet 3/2 { < b-4 > < cis-1-\1 > b }
  \tuplet 3/2 { a gis fis }
  \tuplet 3/2 { e d cis }
  |
                                %23
  \time 4/4
  \arpBarre #5 < e-1-\2 >\downbow < gis-\2 >
  < b-3 > < cis-\1 >
  < e-4 > cis
  b  gis8
  |
                                %24
  \time 5/4
  \tuplet 3/2 { < e-1 >\downbow < fis-3 > < gis-1 > }
  \tuplet 3/2 { < a-2 > < b-4 > < cis-1-\1 > }
  \tuplet 3/2 { < d-3 > < e-4 > d }
  \tuplet 3/2 { cis b a }
  \tuplet 3/2 { gis fis e }
  |
  \bar "|."
}

\book {
  \score {
    \arpCisMSevenIXPhrygianScale
  }
}
