\version "2.24.4"
%% arp.cism7.2noteseq.ly
%% Beginn: 2026-01-13
%% letzte Änderung: 2026-01-13
#(define RH rightHandFinger)

%% \arpBarre
%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})
%% \arpBarre Ende
%% ************************************

arpCisMSevenThreeNotes = \relative c'' {
  \time 4/4
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \tuplet 3/2 { < e-4-\1 >8^\markup "IX."\upbow \arpBarre #-14 < cis-1 >\downbow < b-3-\2 >\upbow }
  \tuplet 3/2 { cis8\upbow b\downbow gis\upbow }
  \tuplet 3/2 { b8\upbow gis\downbow < e-\3 >\upbow }
  \tuplet 3/2 { gis8 e < cis-4-\4 > }
  |
                                %2
  \tuplet 3/2 { e8 cis b }
  \tuplet 3/2 { cis8 b < gis-3-\5 > }
  \tuplet 3/2 { b8 gis < e-4-\6 > }
  \tuplet 3/2 { gis8 e cis }
  |
                                %3
  \tuplet 3/2 { cis8 e < gis-2 > }
  \tuplet 3/2 { e8 gis b }
  \tuplet 3/2 { gis8 b < cis-3 > }
  \tuplet 3/2 { b8 cis e}
  |
                                %4
  \tuplet 3/2 { cis8 e gis }
  \tuplet 3/2 { e8 gis b }
  \tuplet 3/2 { gis8 b cis }
  \tuplet 3/2 { b8 cis e }
  |
  \bar "|."
}

\book {
  \score {
    \arpCisMSevenThreeNotes
  }
}
