\version "2.24.4"
%% arp.cism7.3noteseq.gap.ly
%% Beginn: 2026-01-13
%% letzte Änderung: 2026-01-13
#(define RH rightHandFinger)

%% \arpBarre
%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})
%% \arpBarre Ende
%% ************************************

arpCisMSevenThreeNotesGapThree = \relative c'' {
  \time 4/4
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \tuplet 3/2 { < e-4-\1 >8^\markup "IX."\upbow \arpBarre #-14 < cis-1 >\downbow < b-3-\2 >\upbow }
  r4
  \tuplet 3/2 { cis8\upbow b\downbow gis\upbow }
  r4
  |
                                %2
  \tuplet 3/2 { b8\upbow gis\downbow < e-\3 >\upbow }
  r4
  \tuplet 3/2 { gis8 e < cis-4-\4 > }
  r4
  |
                                %3
  \tuplet 3/2 { e8 cis b }
  r4
  \tuplet 3/2 { cis8 b < gis-3-\5 > }
  r4
  |
                                %4
  \tuplet 3/2 { b8 gis < e-4-\6 > }
  r4
  \tuplet 3/2 { gis8 e cis }
  r4
  |

                                %5
  \tuplet 3/2 { cis8 e < gis-2 > }
  r4
  \tuplet 3/2 { e8 gis b }
  r4
  |
                                %6
  \tuplet 3/2 { gis8 b < cis-3 > }
  r4
  \tuplet 3/2 { b8 cis e}
  r4
  |
                                %7
  \tuplet 3/2 { cis8 e gis }
  r4
  \tuplet 3/2 { e8 gis b }
  r4
  |
                                %8
  \tuplet 3/2 { gis8 b cis }
  r4
  \tuplet 3/2 { b8 cis e }
  r4
  |
  \bar "|."
}

arpCisMSevenThreeNotesGapTwo = \relative c'' {
  \time 4/4
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \tuplet 3/2 { < e-4-\1 >8^\markup "IX."\downbow \arpBarre #-14 < cis-1 >\upbow < b-3-\2 >\downbow }
  \tuplet 3/2 { r4 cis8\downbow }
  \tuplet 3/2 { b8\upbow gis\downbow r }
  \tuplet 3/2 { r8 b8\downbow gis\upbow }
  |
                                %2
  \tuplet 3/2 { < e-\3 >\downbow r4 }
  \tuplet 3/2 { gis8 e < cis-4-\4 > }
  \tuplet 3/2 { r4 e8 }
  \tuplet 3/2 { cis8 b r }
  |
                                %3
  \tuplet 3/2 { r8 cis b }
  \tuplet 3/2 { < gis-3-\5 >8 r4 }
  \tuplet 3/2 { b8 gis < e-4-\6 > }
  \tuplet 3/2 { r4 gis8 }
  |
                                %4
  \tuplet 3/2 { e8 cis r }
  \tuplet 3/2 { r8 cis e }
  \tuplet 3/2 { < gis-2 >8 r4 }
  \tuplet 3/2 { e8 gis b }
  |
                                %5
  \tuplet 3/2 { r4 gis8 }
  \tuplet 3/2 { b8 < cis-3 > r }
  \tuplet 3/2 { r8 b cis }
  \tuplet 3/2 { e8 r4 }
  |
                                %6
  \tuplet 3/2 { cis8 e gis }
  \tuplet 3/2 { r4 e8 }
  \tuplet 3/2 { gis8 b r }
  \tuplet 3/2 { r8 gis b }
  |
                                %7
  \tuplet 3/2 { cis8 r4 }
  \tuplet 3/2 { b8 cis e }
  r2
  |
  \bar "|."
}

arpCisMSevenThreeNotesGapOne = \relative c'' {
  \time 3/4
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \tuplet 3/2 { < e-4-\1 >8^\markup "IX."\upbow \arpBarre #-14 < cis-1 >\downbow < b-3-\2 >\upbow }
  \tuplet 3/2 { r cis\upbow b\downbow }
  \tuplet 3/2 { gis\upbow r b\upbow }
  \tuplet 3/2 { gis\downbow < e-\3 >\upbow r }
  \tuplet 3/2 { gis e < cis-4-\4 > }
  \tuplet 3/2 { r e cis }
  \tuplet 3/2 { b r cis }
  \tuplet 3/2 { b < gis-3-\5 > r }
  \tuplet 3/2 { b gis < e-4-\6 > }
  \tuplet 3/2 { r gis e }
  \tuplet 3/2 { cis r cis }
  \tuplet 3/2 { e < gis-2 > r }
  \tuplet 3/2 { e gis b }
  \tuplet 3/2 { r gis b }
  \tuplet 3/2 { < cis-3 > r b }
  \tuplet 3/2 { cis e r }
  \tuplet 3/2 { cis e gis }
  \tuplet 3/2 { r e gis }
  \tuplet 3/2 { b r gis }
  \tuplet 3/2 { b cis r }
  \tuplet 3/2 { b cis e }

  \bar "|."
}

#(define output-suffix "3")
\book {
  \score {
    \arpCisMSevenThreeNotesGapThree
  }
}

#(define output-suffix "2")
\book {
  \score {
    \arpCisMSevenThreeNotesGapTwo
  }
}

#(define output-suffix "1")
\book {
  \score {
    \arpCisMSevenThreeNotesGapOne
  }
}
