\version "2.24.4"
%% arp.bm7.3noteseq.gap.ly
%% Beginn: 2026-01-16
%% letzte Änderung: 2026-01-16
#(define RH rightHandFinger)

%% \arpBarre
%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})
%% \arpBarre Ende
%% ************************************

arpBMSevenThreeNotesGapThree = \relative c'' {
  \time 4/4
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \tuplet 3/2 { < d-4-\1 >8^\markup "VII."\downbow \arpBarre #-14 < b-1 >\upbow < a-3-\2 >\downbow }
  r4
  \tuplet 3/2 { b8\downbow a\upbow fis\downbow }
  r4
  |
                                %2
  \tuplet 3/2 { a8\downbow fis\upbow < d-\3 >\downbow }
  r4
  \tuplet 3/2 { fis8 d < b-4-\4 > }
  r4
  |
                                %3
  \tuplet 3/2 { d8 b a }
  r4
  \tuplet 3/2 { b8 a < fis-3-\5 > }
  r4
  |
                                %4
  \tuplet 3/2 { a8 fis < d-4-\6 > }
  r4
  \tuplet 3/2 { fis8 d b }
  r4
  |

                                %5
  \tuplet 3/2 { b8 d < fis-2 > }
  r4
  \tuplet 3/2 { d8 fis a }
  r4
  |
                                %6
  \tuplet 3/2 { fis8 a < b-3 > }
  r4
  \tuplet 3/2 { a8 b d}
  r4
  |
                                %7
  \tuplet 3/2 { b8 d fis }
  r4
  \tuplet 3/2 { d8 fis a }
  r4
  |
                                %8
  \tuplet 3/2 { fis8 a b }
  r4
  \tuplet 3/2 { a8 b d }
  r4
  |
  \bar "|."
}

arpBMSevenThreeNotesGapTwo = \relative c'' {
  \time 4/4
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \tuplet 3/2 { < d-4-\1 >8^\markup "VII."\upbow \arpBarre #-14 < b-1 >\downbow < a-3-\2 >\upbow }
  \tuplet 3/2 { r4 b8\downbow }
  \tuplet 3/2 { a8\upbow fis\downbow r }
  \tuplet 3/2 { r8 a8\upbow fis\downbow }
  |
                                %2
  \tuplet 3/2 { < d-\3 >\upbow r4 }
  \tuplet 3/2 { fis8 d < b-4-\4 > }
  \tuplet 3/2 { r4 d8 }
  \tuplet 3/2 { b8 a r }
  |
                                %3
  \tuplet 3/2 { r8 b a }
  \tuplet 3/2 { < fis-3-\5 >8 r4 }
  \tuplet 3/2 { a8 fis < d-4-\6 > }
  \tuplet 3/2 { r4 fis8 }
  |
                                %4
  \tuplet 3/2 { d8 b r }
  \tuplet 3/2 { r8 b d }
  \tuplet 3/2 { < fis-2 >8 r4 }
  \tuplet 3/2 { d8 fis a }
  |
                                %5
  \tuplet 3/2 { r4 fis8 }
  \tuplet 3/2 { a8 < b-3 > r }
  \tuplet 3/2 { r8 a b }
  \tuplet 3/2 { d8 r4 }
  |
                                %6
  \tuplet 3/2 { b8 d fis }
  \tuplet 3/2 { r4 d8 }
  \tuplet 3/2 { fis8 a r }
  \tuplet 3/2 { r8 fis a }
  |
                                %7
  \tuplet 3/2 { b8 r4 }
  \tuplet 3/2 { a8 b d }
  r2
  |
  \bar "|."
}

arpBMSevenThreeNotesGapOne = \relative c'' {
  \time 3/4
  \key a \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

                                %1
  \tuplet 3/2 { < d-4-\1 >8^\markup "VII."\downbow \arpBarre #-14 < b-1 >\upbow < a-3-\2 >\downbow }
  \tuplet 3/2 { r b\downbow a\upbow }
  \tuplet 3/2 { fis\downbow r a\downbow }
  \tuplet 3/2 { fis\upbow < d-\3 >\downbow r }
  \tuplet 3/2 { fis d < b-4-\4 > }
  \tuplet 3/2 { r d b }
  \tuplet 3/2 { a r b }
  \tuplet 3/2 { a < fis-3-\5 > r }
  \tuplet 3/2 { a fis < d-4-\6 > }
  \tuplet 3/2 { r fis d }
  \tuplet 3/2 { b r b }
  \tuplet 3/2 { d < fis-2 > r }
  \tuplet 3/2 { d fis a }
  \tuplet 3/2 { r fis a }
  \tuplet 3/2 { < b-3 > r a }
  \tuplet 3/2 { b d r }
  \tuplet 3/2 { b d fis }
  \tuplet 3/2 { r d fis }
  \tuplet 3/2 { a r fis }
  \tuplet 3/2 { a b r }
  \tuplet 3/2 { a b d }

  \bar "|."
}

#(define output-suffix "3")
\book {
  \score {
    \arpBMSevenThreeNotesGapThree
  }
}

#(define output-suffix "2")
\book {
  \score {
    \arpBMSevenThreeNotesGapTwo
  }
}

#(define output-suffix "1")
\book {
  \score {
    \arpBMSevenThreeNotesGapOne
  }
}
