\version "2.24"
%% alternate_picking.growing_Barre.flagolett.ly
%% Beginn: 2025-12-19
%% letzte Änderung: 2025-12-19
#(define RH rightHandFinger)

%% \arpBarre
%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})
%% \arpBarre Ende
%% ************************************


alternatePickingGrowingBarreFlagolettOneTwo = \relative c'' {
  \time 5/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

  \repeat volta 2 {
                                %1
    \arpBarre #-3 < e-1\harmonic >8^\downbow^\markup "XII." b\harmonic\upbow
    \arpBarre #-2 b\harmonic\downbow g\harmonic\upbow
    \arpBarre #-3 g8\harmonic\downbow d\harmonic\upbow
    \arpBarre #-3 d8\harmonic\downbow a\harmonic\upbow
    \arpBarre #-3 a8\harmonic\downbow e\harmonic\upbow
    |
                                %2
    \arpBarre #3 e\harmonic\downbow a\harmonic\upbow
    \arpBarre #3 a8\harmonic\downbow d\harmonic\upbow
    \arpBarre #3 d8\harmonic\downbow g\harmonic\upbow
    \arpBarre #2 g8\harmonic\downbow b\harmonic\upbow
    \arpBarre #3 b\harmonic\downbow e\harmonic\upbow
    |
                                %3
    \arpBarre #-3 d8\harmonic\downbow b\harmonic\upbow
    \arpBarre #-2 b\harmonic\downbow g\harmonic\upbow
    \arpBarre #-3 g8\harmonic\downbow d\harmonic\upbow
    \arpBarre #-3 d8\harmonic\downbow a\harmonic\upbow
    \arpBarre #-3 a8\harmonic\downbow e\harmonic\upbow
  }
}

alternatePickingGrowingBarreFlagolettThreeThree = \relative c'' {
  \time 4/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

  \repeat volta 2 {
                                %1
    \tuplet 3/2 { \arpBarre #-5 < e-3\harmonic >8\downbow^\markup "XII." b\harmonic\upbow g\harmonic\downbow }
    \tuplet 3/2 { \arpBarre #-5 b8\harmonic\upbow g\harmonic\downbow d\harmonic\upbow }
    \tuplet 3/2 { \arpBarre #-5 g8\harmonic\downbow d\harmonic\upbow a\harmonic\downbow }
    \tuplet 3/2 { \arpBarre #-6 d\harmonic\upbow a\harmonic\downbow e\harmonic\upbow }
    |
                                %2
    \tuplet 3/2 { \arpBarre #6 e8\harmonic\downbow a\harmonic\upbow d\harmonic\downbow }
    \tuplet 3/2 { \arpBarre #5 a8\harmonic\upbow d\harmonic\downbow g\harmonic\upbow }
    \tuplet 3/2 { \arpBarre #5 d8\harmonic\downbow g\harmonic\upbow b\harmonic\downbow }
    \tuplet 3/2 { \arpBarre #5 g\harmonic\upbow b\harmonic\downbow e\harmonic\upbow }
    |
                                %3
    \tuplet 3/2 { \arpBarre #-5 e8\harmonic\downbow b\harmonic\upbow g\harmonic\downbow }
    \tuplet 3/2 { \arpBarre #-5 b8\harmonic\upbow g\harmonic\downbow d\harmonic\upbow }
    \tuplet 3/2 { \arpBarre #-5 g8\harmonic\downbow d\harmonic\upbow a\harmonic\downbow }
    \tuplet 3/2 { \arpBarre #-6 d\harmonic\upbow a\harmonic\downbow e\harmonic\upbow }
    |
  }
}

alternatePickingGrowingBarreFlagolettTwoFour = \relative c'' {
  \time 6/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside
  \set Timing.beatStructure = 2,2,2

  \repeat volta 2 {
                                %1
    \arpBarre #-8 < e-2\harmonic >8\downbow^\markup "XII." b\harmonic\upbow
    g\harmonic\downbow d\harmonic\upbow
    \arpBarre #-8 b'\harmonic\downbow g\harmonic\upbow
    d\harmonic\downbow a\harmonic\upbow
    \arpBarre #-8 g'\harmonic\downbow d\harmonic\upbow
    a\harmonic\downbow e\harmonic\upbow
    |
                                %2
    \arpBarre #8 e\harmonic\downbow a\harmonic\upbow
    d\harmonic\downbow g\harmonic\upbow
    \arpBarre #8 a,\harmonic\downbow d\harmonic\upbow
    g\harmonic\downbow b\harmonic\upbow
    \arpBarre #8 d,\harmonic\downbow g\harmonic\upbow
    b\harmonic\downbow e\harmonic\upbow
                                %3
    \arpBarre #-8 e8\harmonic\downbow b\harmonic\upbow
    g\harmonic\downbow d\harmonic\upbow
    \arpBarre #-8 b'\harmonic\downbow g\harmonic\upbow
    d\harmonic\downbow a\harmonic\upbow
    \arpBarre #-8 g'\harmonic\downbow d\harmonic\upbow
    a\harmonic\downbow e\harmonic\upbow
    |
  }
}

alternatePickingGrowingBarreFlagolettFourFive = \relative c'' {
  \time 10/8
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside
  \set Timing.beatStructure = 5,5

  \repeat volta 2 {
                                %1
    \arpBarre #-11 < e-4\harmonic >8\downbow^\markup "XII.." b\harmonic\upbow g\harmonic\downbow d\harmonic\upbow a\harmonic\downbow
    \arpBarre #-11 b'\harmonic\upbow g\harmonic\downbow d\harmonic\upbow a\harmonic\downbow e\harmonic\upbow |
                                %2
    \arpBarre #11 e\harmonic\downbow a\harmonic\upbow d\harmonic\downbow g\harmonic\upbow b\harmonic\downbow
    \arpBarre #11 a,\harmonic\upbow d\harmonic\downbow g\harmonic\upbow b\harmonic\downbow e\harmonic\upbow |
                                %3
    \arpBarre #-11 e8\harmonic\downbow b\harmonic\upbow g\harmonic\downbow d\harmonic\upbow a\harmonic\downbow
    \arpBarre #-11 b'\harmonic\upbow g\harmonic\downbow d\harmonic\upbow a\harmonic\downbow e\harmonic\upbow |
  }
}

alternatePickingGrowingBarreFlagolettOneSix = \relative c'' {
  \time 6/8
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside
  \set Timing.beatStructure = 6,0

  \repeat volta 2 {
                                %1
    \arpBarre #-15 < e-1\harmonic >8\downbow^\markup "XII." b\harmonic\upbow g\harmonic\downbow
    d\harmonic\upbow a\harmonic\downbow e\harmonic\upbow |
                                %2
    \arpBarre #15 e8\harmonic\downbow a\harmonic\upbow d\harmonic\downbow
    g\harmonic\upbow b\harmonic\downbow e\harmonic\upbow |
                                %3
    \arpBarre #-15 e8\harmonic\downbow b\harmonic\upbow g\harmonic\downbow
    d\harmonic\upbow a\harmonic\downbow e\harmonic\upbow |
  }
}

alternatePickingGrowingBarreFlagolettThreeTwo = \relative c'' {
  \time 5/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

  \repeat volta 2 {
                                %1
    \arpBarre #-3 < a-3\harmonic >8\downbow^\markup "V." e\harmonic\upbow
    \arpBarre #-2 e\harmonic\downbow c\harmonic\upbow
    \arpBarre #-3 c8\harmonic\downbow g\harmonic\upbow
    \arpBarre #-3 g8\harmonic\downbow d\harmonic\upbow
    \arpBarre #-3 d8\harmonic\downbow a\harmonic\upbow
    |
                                %2
    \arpBarre #3 a\harmonic\downbow d\harmonic\upbow
    \arpBarre #3 d8\harmonic\downbow g\harmonic\upbow
    \arpBarre #3 g8\harmonic\downbow c\harmonic\upbow
    \arpBarre #2 c8\harmonic\downbow e\harmonic\upbow
    \arpBarre #3 e\harmonic\downbow a\harmonic\upbow
    |
                                %3
    \arpBarre #-3 a8\harmonic\downbow  e\harmonic\upbow
    \arpBarre #-2 e\harmonic\downbow c\harmonic\upbow
    \arpBarre #-3 c8\harmonic\downbow g\harmonic\upbow
    \arpBarre #-3 g8\harmonic\downbow d\harmonic\upbow
    \arpBarre #-3 d8\harmonic\downbow a\harmonic\upbow
  }
}

#(define output-suffix "1-2")
\book {
  \score {
    \alternatePickingGrowingBarreFlagolettOneTwo
  }
}

#(define output-suffix "3-3")
\book {
  \score {
    \alternatePickingGrowingBarreFlagolettThreeThree
  }
}

#(define output-suffix "2-4")
\book {
  \score {
    \alternatePickingGrowingBarreFlagolettTwoFour
  }
}

#(define output-suffix "4-5")
\book {
  \score {
    \alternatePickingGrowingBarreFlagolettFourFive
  }
}

#(define output-suffix "1-6")
\book {
  \score {
    \alternatePickingGrowingBarreFlagolettOneSix
  }
}

#(define output-suffix "3-2")
\book {
  \score {
    \alternatePickingGrowingBarreFlagolettThreeTwo
  }
}
