\version "2.24"
%% alternate_picking.growing_Barre.VII.ly
%% Beginn: 2025-12-19
%% letzte Änderung: 2025-12-19
#(define RH rightHandFinger)

%% \arpBarre
%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})
%% \arpBarre Ende
%% ************************************


alternatePickingGrowingBarreVIIFourTwo = \relative c'' {
  \time 5/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

  \repeat volta 2 {
                                %1
    \arpBarre #-3 < d-4 >8^\downbow^\markup "VII." a\upbow
    \arpBarre #-2 a^\downbow e\upbow
    \arpBarre #-3 e8^\downbow c\upbow
    \arpBarre #-3 c8^\downbow g\upbow
    \arpBarre #-3 g8^\downbow d\upbow
    |
                                %2
    \arpBarre #3 d^\downbow g\upbow
    \arpBarre #3 g8^\downbow c\upbow
    \arpBarre #3 c8^\downbow e\upbow
    \arpBarre #2 e8^\downbow a\upbow
    \arpBarre #3 a^\downbow d\upbow
    |
                                %3
    \arpBarre #-3 d8^\downbow a\upbow
    \arpBarre #-2 a^\downbow e\upbow
    \arpBarre #-3 e8^\downbow c\upbow
    \arpBarre #-3 c8^\downbow g\upbow
    \arpBarre #-3 g8^\downbow d\upbow
  }
}

alternatePickingGrowingBarreVIIThreeThree = \relative c'' {
  \time 4/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

  \repeat volta 2 {
                                %1
    \tuplet 3/2 { \arpBarre #-5 < cis-3 >8\downbow^\markup "VII." gis\upbow e\downbow }
    \tuplet 3/2 { \arpBarre #-5 gis8\upbow dis\downbow b\upbow }
    \tuplet 3/2 { \arpBarre #-5 dis8\downbow b\upbow fis\downbow }
    \tuplet 3/2 { \arpBarre #-6 b\upbow fis\downbow cis\upbow }
    |
                                %2
    \tuplet 3/2 { \arpBarre #6 cis8\downbow fis\upbow b\downbow }
    \tuplet 3/2 { \arpBarre #5 fis8\upbow b\downbow e\upbow }
    \tuplet 3/2 { \arpBarre #5 b8\downbow e\upbow gis\downbow }
    \tuplet 3/2 { \arpBarre #5 e\upbow gis\downbow cis\upbow }
    |
                                %3
    \tuplet 3/2 { \arpBarre #-5 cis8\downbow gis\upbow e\downbow }
    \tuplet 3/2 { \arpBarre #-5 gis8\upbow e\downbow b\upbow }
    \tuplet 3/2 { \arpBarre #-5 e8\downbow b\upbow fis\downbow }
    \tuplet 3/2 { \arpBarre #-6 b\upbow fis\downbow cis\upbow }
    |
  }
}

alternatePickingGrowingBarreVIITwoFour = \relative c'' {
  \time 6/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside
  \set Timing.beatStructure = 2,2,2

  \repeat volta 2 {
                                %1
    \arpBarre #-8 < c-2 >8\downbow^\markup "VII." g\upbow
    es\downbow bes\upbow
    \arpBarre #-8 g'\downbow es\upbow
    bes\downbow f\upbow
    \arpBarre #-8 es'\downbow bes\upbow
    f\downbow c\upbow
    |
                                %2
    \arpBarre #8 c\downbow g\upbow
    bes\downbow es\upbow
    \arpBarre #8 f,\downbow bes\upbow
    es\downbow g\upbow
    \arpBarre #8 bes,\downbow es\upbow
    g\downbow c\upbow
                                %3
    \arpBarre #-8 c8 g\upbow
    es\downbow bes\upbow
    \arpBarre #-8 g'\downbow es\upbow
    bes\downbow f\upbow
    \arpBarre #-8 es'\downbow bes\upbow
    f\downbow c\upbow
    |
  }
}

alternatePickingGrowingBarreVIIOneFive = \relative c'' {
  \time 10/8
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside
  \set Timing.beatStructure = 5,5

  \repeat volta 2 {
                                %1
    \arpBarre #-11 < b-1 >8\downbow^\markup "VII." fis\upbow d\downbow a\upbow e\downbow
    \arpBarre #-11 fis'\upbow d\downbow a\upbow e\downbow b\upbow |
                                %2
    \arpBarre #11 b\downbow e\upbow a\downbow d\upbow fis\downbow
    \arpBarre #11 e,\upbow a\downbow d\upbow fis\downbow b\upbow |
                                %3
    \arpBarre #-11 b8\downbow fis\upbow d\downbow a\upbow e\downbow
    \arpBarre #-11 fis'\upbow d\downbow a\upbow e\downbow b\upbow |
  }
}

alternatePickingGrowingBarreVIIFourSix = \relative c'' {
  \time 6/8
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside
  \set Timing.beatStructure = 6,0

  \repeat volta 2 {
                                %1
    \arpBarre #-15 < d-4 >8\downbow^\markup "VII" a\upbow e\downbow
    c\upbow g\downbow g\upbow |
                                %2
    \arpBarre #15 d8\downbow g\upbow c\downbow
    e\upbow a\downbow d\upbow |
                                %3
    \arpBarre #-15 d8\downbow a\upbow e\downbow
    c\upbow g\downbow g\upbow |
  }
}

alternatePickingGrowingBarreVIIThreeTwo = \relative c'' {
  \time 5/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

  \repeat volta 2 {
                                %1
    \arpBarre #-3 < cis-3 >8^\downbow^\markup "VII." gis\upbow
    \arpBarre #-2 gis^\downbow e\upbow
    \arpBarre #-3 e8^\downbow b\upbow
    \arpBarre #-3 b8^\downbow fis\upbow
    \arpBarre #-3 fis8^\downbow cis\upbow
    |
                                %2
    \arpBarre #3 cis^\downbow fis\upbow
    \arpBarre #3 fis8^\downbow b\upbow
    \arpBarre #3 b8^\downbow e\upbow
    \arpBarre #2 e8^\downbow gis\upbow
    \arpBarre #3 gis^\downbow cis\upbow
    |
                                %3
    \arpBarre #-3 cis8^\downbow  gis\upbow
    \arpBarre #-2 gis^\downbow e\upbow
    \arpBarre #-3 e8^\downbow b\upbow
    \arpBarre #-3 b8^\downbow fis\upbow
    \arpBarre #-3 fis8^\downbow cis\upbow
  }
}

alternatePickingGrowingBarreVIIOneSix = \relative c'' {
  \time 6/8
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside
  \set Timing.beatStructure = 6,0

  \repeat volta 2 {
                                %1
    \arpBarre #-15 < b-1 >8\downbow^\markup "VII." fis\upbow d\downbow
    a\upbow e\downbow b\upbow |
                                %2
    \arpBarre #15 b8\downbow e\upbow a\downbow
    d\upbow fis\downbow b\upbow |
                                %3
    \arpBarre #-15 b8\downbow fis\upbow d\downbow
    a\upbow e\downbow b\upbow
  }
}

#(define output-suffix "4-2")
\book {
  \score {
    \alternatePickingGrowingBarreVIIFourTwo
  }
}

#(define output-suffix "3-3")
\book {
  \score {
    \alternatePickingGrowingBarreVIIThreeThree
  }
}

#(define output-suffix "2-4")
\book {
  \score {
    \alternatePickingGrowingBarreVIITwoFour
  }
}

#(define output-suffix "1-5")
\book {
  \score {
    \alternatePickingGrowingBarreVIIOneFive
  }
}

#(define output-suffix "4-6")
\book {
  \score {
    \alternatePickingGrowingBarreVIIFourSix
  }
}

#(define output-suffix "3-2")
\book {
  \score {
    \alternatePickingGrowingBarreVIIThreeTwo
  }
}

#(define output-suffix "1-6")
\book {
  \score {
    \alternatePickingGrowingBarreVIIOneSix
  }
}

