\version "2.24"
%% alternate_picking.growing_Barre.V.ly
%% Beginn: 2025-12-18
%% letzte Änderung: 2025-12-18
#(define RH rightHandFinger)

%% \arpBarre
%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})
%% \arpBarre Ende
%% ************************************


alternatePickingGrowingBarreVOneTwo = \relative c'' {
  \time 5/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

  \repeat volta 2 {
                                %1
    \arpBarre #-3 < a-1 >8^\downbow^\markup "V." e\upbow
    \arpBarre #-2 e^\downbow c\upbow
    \arpBarre #-3 c8^\downbow g\upbow
    \arpBarre #-3 g8^\downbow d\upbow
    \arpBarre #-3 d8^\downbow a\upbow
    |
                                %2
    \arpBarre #3 a^\downbow d\upbow
    \arpBarre #3 d8^\downbow g\upbow
    \arpBarre #3 g8^\downbow c\upbow
    \arpBarre #2 c8^\downbow e\upbow
    \arpBarre #3 e^\downbow a\upbow
    |
                                %3
    \arpBarre #-3 a8^\downbow e\upbow
    \arpBarre #-2 e^\downbow c\upbow
    \arpBarre #-3 c8^\downbow g\upbow
    \arpBarre #-3 g8^\downbow d\upbow
    \arpBarre #-3 d8^\downbow a\upbow
  }
}

alternatePickingGrowingBarreVTwoThree = \relative c'' {
  \time 4/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

  \repeat volta 2 {
                                %1
    \tuplet 3/2 { \arpBarre #-5 < bes-2 >8\downbow^\markup "V." f\upbow des\downbow }
    \tuplet 3/2 { \arpBarre #-5 f8\upbow des\downbow as\upbow }
    \tuplet 3/2 { \arpBarre #-5 des8\downbow as\upbow es\downbow }
    \tuplet 3/2 { \arpBarre #-6 as\upbow es\downbow bes\upbow }
    |
                                %2
    \tuplet 3/2 { \arpBarre #6 bes8\downbow es\upbow as\downbow }
    \tuplet 3/2 { \arpBarre #5 es8\upbow as\downbow des\upbow }
    \tuplet 3/2 { \arpBarre #5 as8\downbow des\upbow f\downbow }
    \tuplet 3/2 { \arpBarre #5 des\upbow f\downbow bes\upbow }
    |
                                %3
    \tuplet 3/2 { \arpBarre #-5 bes8\downbow f\upbow des\downbow }
    \tuplet 3/2 { \arpBarre #-5 f8\upbow des\downbow as\upbow }
    \tuplet 3/2 { \arpBarre #-5 des8\downbow as\upbow es\downbow }
    \tuplet 3/2 { \arpBarre #-6 as\upbow es\downbow bes\upbow }
    |
  }
}

alternatePickingGrowingBarreVThreeFour = \relative c'' {
  \time 6/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside
  \set Timing.beatStructure = 2,2,2

  \repeat volta 2 {
                                %1
    \arpBarre #-8 < b-3 >8\downbow^\markup "V." fis\upbow
    d\downbow a\upbow
    \arpBarre #-8 fis'\downbow d\upbow
    a\downbow e\upbow
    \arpBarre #-8 d'\downbow a\upbow
    e\downbow b\upbow
    |
                                %2
    \arpBarre #8 b\downbow e\upbow
    a\downbow d\upbow
    \arpBarre #8 e,\downbow a\upbow
    d\downbow fis\upbow
    \arpBarre #8 a,\downbow d\upbow
    fis\downbow b\upbow
                                %3
    \arpBarre #-8 b8 fis\upbow
    d\downbow a\upbow
    \arpBarre #-8 fis'\downbow d\upbow
    a\downbow e\upbow
    \arpBarre #-8 d'\downbow a\upbow
    e\downbow b\upbow
    |
  }
}

alternatePickingGrowingBarreVFourFive = \relative c'' {
  \time 10/8
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside
  \set Timing.beatStructure = 5,5

  \repeat volta 2 {
                                %1
    \arpBarre #-11 < c-4 >8\downbow^\markup "V." g\upbow es\downbow bes\upbow f\downbow
    \arpBarre #-11 g'\upbow es\downbow bes\upbow f\downbow c\upbow |
                                %2
    \arpBarre #11 c\downbow f\upbow bes\downbow es\upbow g\downbow
    \arpBarre #11 f,\upbow bes\downbow es\upbow g\downbow c\upbow |
                                %3
    \arpBarre #-11 c8\downbow g\upbow es\downbow bes\upbow f\downbow
    \arpBarre #-11 g'\upbow es\downbow bes\upbow f\downbow c\upbow |
  }
}

alternatePickingGrowingBarreVOneSix = \relative c'' {
  \time 6/8
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside
  \set Timing.beatStructure = 6,0

  \repeat volta 2 {
                                %1
    \arpBarre #-15 < a-1 >8\downbow^\markup "V." e\upbow c\downbow
    g\upbow d\downbow a\upbow
                                %2
    \arpBarre #15 a8\downbow d\upbow g\downbow
    c\upbow e\downbow a\upbow
                                %3
    \arpBarre #-15 a8\downbow e\upbow c\downbow
    g\upbow d\downbow a\upbow
  }
}

alternatePickingGrowingBarreVTwoTwo = \relative c'' {
  \time 5/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

  \repeat volta 2 {
                                %1
    \arpBarre #-3 < bes-2 >8^\downbow^\markup "V." f\upbow
    \arpBarre #-2 f^\downbow des\upbow
    \arpBarre #-3 des8^\downbow as\upbow
    \arpBarre #-3 as8^\downbow es\upbow
    \arpBarre #-3 es8^\downbow bes\upbow
    |
                                %2
    \arpBarre #3 bes^\downbow es\upbow
    \arpBarre #3 es8^\downbow as\upbow
    \arpBarre #3 as8^\downbow des\upbow
    \arpBarre #2 des8^\downbow f\upbow
    \arpBarre #3 f^\downbow bes\upbow
    |
                                %3
    \arpBarre #-3 bes8^\downbow f\upbow
    \arpBarre #-2 f^\downbow des\upbow
    \arpBarre #-3 des8^\downbow as\upbow
    \arpBarre #-3 as8^\downbow f\upbow
    \arpBarre #-3 f8^\downbow bes\upbow
  }
}

alternatePickingGrowingBarreVThreeThree = \relative c'' {
  \time 4/4
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside

  \repeat volta 2 {
                                %1
    \tuplet 3/2 { \arpBarre #-5 < b-3 >8\downbow^\markup "V." fis\upbow d\downbow }
    \tuplet 3/2 { \arpBarre #-5 fis8\upbow d\downbow a\upbow }
    \tuplet 3/2 { \arpBarre #-5 d8\downbow a\upbow e\downbow }
    \tuplet 3/2 { \arpBarre #-6 a\upbow e\downbow b\upbow }
    |
                                %2
    \tuplet 3/2 { \arpBarre #6 b8\downbow e\upbow a\downbow }
    \tuplet 3/2 { \arpBarre #5 e8\upbow a\downbow d\upbow }
    \tuplet 3/2 { \arpBarre #5 a8\downbow d\upbow fis\downbow }
    \tuplet 3/2 { \arpBarre #5 d\upbow fis\downbow b\upbow }
    |
                                %3
    \tuplet 3/2 { \arpBarre #-5 b8\downbow fis\upbow d\downbow }
    \tuplet 3/2 { \arpBarre #-5 fis8\upbow d\downbow a\upbow }
    \tuplet 3/2 { \arpBarre #-5 d8\downbow a\upbow e\downbow }
    \tuplet 3/2 { \arpBarre #-6 a\upbow e\downbow b\upbow }
    |
  }
}

alternatePickingGrowingBarreVFourSix = \relative c'' {
  \time 6/8
  \key c \major
  \clef "treble_8"

  \set fingeringOrientations = #'(left)
  \set strokeFingerOrientations = #'(down)
  \override StrokeFinger.avoid-slur = #'inside
  \set Timing.beatStructure = 6,0

  \repeat volta 2 {
                                %1
    \arpBarre #-15 < c-1 >8\downbow^\markup "V." g\upbow es\downbow
    bes\upbow f\downbow c\upbow
                                %2
    \arpBarre #15 c8\downbow f\upbow bes\downbow
    es\upbow g\downbow c\upbow
                                %3
    \arpBarre #-15 c8\downbow g\upbow es\downbow
    bes\upbow f\downbow c\upbow
  }
}

#(define output-suffix "1-2")
\book {
  \score {
    \alternatePickingGrowingBarreVOneTwo
  }
}

#(define output-suffix "2-3")
\book {
  \score {
    \alternatePickingGrowingBarreVTwoThree
  }
}

#(define output-suffix "3-4")
\book {
  \score {
    \alternatePickingGrowingBarreVThreeFour
  }
}

#(define output-suffix "4-5")
\book {
  \score {
    \alternatePickingGrowingBarreVFourFive
  }
}

#(define output-suffix "1-6")
\book {
  \score {
    \alternatePickingGrowingBarreVOneSix
  }
}

#(define output-suffix "2-2")
\book {
  \score {
    \alternatePickingGrowingBarreVTwoTwo
  }
}

#(define output-suffix "3-3")
\book {
  \score {
    \alternatePickingGrowingBarreVThreeThree
  }
}

#(define output-suffix "4-6")
\book {
  \score {
    \alternatePickingGrowingBarreVFourSix
  }
}

