\version "2.24.4"
%% barre_VII.pm.ly
%% letzte Bearbeitung 2026-01-08

%% %% ************************************
%% %% Gitarrekram
#(define RH rightHandFinger)

%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})

%% %% Gitarrenkram Ende
%% %% ************************************

barreVIIPmOne = \relative c'' {
  \key c \major
  \time 4/4
  \clef "treble_8"

                                %Einstellungen
  <<
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left)
    } \\
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left) }
  >>

                                %1
  <<
    { \stemUp < b-1-\RH #1 >16^\markup "VII." < b-\RH #3 > < b-\RH #1 > \tieUp < b-\RH #3 >~
      \arpBarre #-3 b4
      \stemDown < d,-1 >16 d d d~
      \arpBarre #-2 \stemUp d4 | } \\
    { \stemDown s4
      < fis-1 >16 fis fis \tieUp fis~
      \arpBarre #-3 \stemUp fis4
      \stemDown < a,-1 >16 a a a~ | }
  >>
                                %2
  <<
    { \stemDown < e-1 >16 e e e~
      \arpBarre #-3 \stemUp e4
      \stemDown b16 b b \tieDown b~
      \arpBarre #3 b4 | } \\
    { \arpBarre #-3 \stemUp a'4
      \stemDown < b,-1 >16 b b b
      s4
      \stemUp < e-1 >16 e e e~ | }
  >>
                                %3
  <<
    { \stemUp < a-1 >16 a a \tieDown a~
      \arpBarre #3 \stemDown a4
      \stemUp < fis'-1 >16 fis fis fis~
      \arpBarre #3 \stemDown fis4 |} \\
    { \arpBarre #3 \stemDown e,4
      \stemUp < d'-1 >16 d d d~
      \arpBarre #2 \stemDown d4
      \stemUp < b'-1 >16 b b b | }
  >>
  \bar "||"

                                %4
  <<
    { \stemUp < c,,-2-\RH #1 >16 < c-\RH #3 > < c-\RH #1 > \tieDown < c-\RH #3 >~
      \arpBarre #3 \stemDown c4
      \stemUp  < ais'-2 >16 ais ais ais~
      \arpBarre #3 \stemDown ais4 | } \\
    { \stemUp s4
      < f-2 >16 f f f~
      \arpBarre #3 \stemDown f4
      \stemUp < dis'-2 >16 dis dis dis~ | }
  >>
                                %5
  <<
    { \stemUp < g-2 >16 g g \tieDown g~
      \arpBarre #3 \stemDown g4
      \stemUp c16 c c \tieUp c~
      c4 | } \\
    { \arpBarre #2 \stemDown dis,4
      \stemUp < c'-2 >16 c c c
      s4
      \stemDown < g-2 >16 g g \tieUp g~ | }
  >>
                                %6
  <<
    { \stemDown < dis-2 >16 dis dis dis~
      \arpBarre #-3 \stemUp dis4
      \stemDown < f,-2 >16 f f  \tieUp f~
      \arpBarre #-3 \stemUp f4 |} \\
    { \arpBarre #-2 \stemUp g'4
      \stemDown < ais,-2 >16 ais ais \tieUp ais~
      \arpBarre #-3 \stemUp ais4
      \stemDown < c,-2 >16 c c c | }
  >>
  \bar "||"
}

barreVIIPmSeven = \relative c'' {
  \key c \major
  \time 4/4
  \clef "treble_8"
  \override Staff.TimeSignature.stencil = ##f

  <<
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left)
    } \\
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left) }
  >>

                                %7
  <<
    { \stemUp < cis-3-\RH #1 >16 < cis-\RH #3 > < cis-\RH #1 > \tieUp < cis-\RH #3 >~
      \arpBarre #-3 cis4
      \stemDown < e,-3 >16 e e e~
      \arpBarre #-3 \stemUp e4 | } \\
    { \stemDown s4
      < gis-3 >16 gis gis \tieUp gis~
      \arpBarre #-3 \stemUp gis4
      \stemDown < b,-3 >16 b b b~ | }
  >>
                                %8
  <<
    { \stemDown < fis-3 >16 fis fis fis~
      \arpBarre #-3 \stemUp fis4
      \stemDown cis16 cis cis \tieDown cis~
      \arpBarre #3 cis4 | } \\
    { \arpBarre #-3 \stemUp b'4
      \stemDown < cis,-3 >16 cis cis cis
      s4
      \stemUp < fis-3 >16 fis fis fis~ | }
  >>
                                %9
  <<
    { \stemUp < b-3 >16 b b \tieDown b~
      \arpBarre #3 \stemDown b4
      \stemUp < gis'-3 >16 gis gis gis~
      \arpBarre #3 \stemDown gis4 |} \\
    { \arpBarre #3 \stemDown fis,4
      \stemUp < e'-3 >16 e e e~
      \arpBarre #2 \stemDown e4
      \stemUp < cis'-3 >16 cis cis cis | }
  >>
  \bar "||"

                                %10
  <<
    { \stemUp < d,,-4-\RH #1 >16 < d-\RH #3 > < d-\RH #1 > \tieDown < d-\RH #3 >~
      \arpBarre #3 \stemDown d4
      \stemUp  < c'-4 >16 c c c~
      \arpBarre #3 \stemDown c4 | } \\
    { \stemUp s4
      < g-4 >16 g g g~
      \arpBarre #3 \stemDown g4
      \stemUp < f'-4 >16 f f f~ | }
  >>
                                %11
  <<
    { \stemUp < a-4 >16 a a \tieDown a~
      \arpBarre #3 \stemDown a4
      \stemUp d16 d d \tieUp d~
      d4 | } \\
    { \arpBarre #2 \stemDown f,4
      \stemUp < d'-4 >16 d d d
      s4
      \stemDown < a-4 >16 a a \tieUp a~ | }
  >>
                                %12
  <<
    { \stemDown < f-4 >16 f f f~
      \arpBarre #-3 \stemUp f4
      \stemDown < g,-4 >16 g g  \tieUp g~
      \arpBarre #-3 \stemUp g4 |} \\
    { \arpBarre #-2 \stemUp a'4
      \stemDown < c,-4 >16 c c \tieUp c~
      \arpBarre #-3 \stemUp c4
      \stemDown < d,-4 >16 d d d | }
  >>
  \bar "|."
}

% barreVIIPm = {
%   \barreVIIPmOne
%   \barreVIIPmSeven
% }

% \book {
%   \score {
%     \barreVIIPm
%   }
% }

#(define output-suffix "1")
\book {
  \score {
  \barreVIIPmOne
  }
}

#(define output-suffix "2")
\book {
  \paper { indent = 0.0 }

  \score {
  \barreVIIPmSeven
  }
}
