\version "2.24.0"
%% barre_V.pm.ly
%% letzte Bearbeitung 2025-11-25

%% %% ************************************
%% %% Gitarrekram
#(define RH rightHandFinger)

%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})

%% %% Gitarrenkram Ende
%% %% ************************************

                                % und hier die Noten
barreVPm = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

                                %1
  <<
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left)
      \stemUp < a-1-\RH #1 >16^\markup "V." < a-\RH #3 > < a-\RH #1 > \tieDown < a-\RH #3 >~
      \arpBarre #3 \stemDown a4
      \stemUp  < g'-1 >16 g g g~
      \arpBarre #3 \stemDown g4 | } \\
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left)
      \stemUp s4
      < d-1 >16 d d d~
      \arpBarre #3 \stemDown d4
      \stemUp < c'-1 >16 c c c~ | }
  >>
                                %2
  <<
    { \stemUp < e-1 >16 e e \tieDown e~
      \arpBarre #3 \stemDown e4
      \stemUp a16 a a \tieUp a~
      a4 | } \\
    { \arpBarre #2 \stemDown c,4
      \stemUp < a'-1 >16 a a a
      s4
      \stemDown < e-1 >16 e e e~ | }
  >>
                                %3
  <<
    { \stemDown < c-1 >16 c c c~
      \arpBarre #-3 \stemUp c4
      \stemDown < d,-1 >16 d d  \tieUp d~
      \arpBarre #-3 \stemUp d4 |} \\
    { \arpBarre #-2 \stemUp e'4
      \stemDown < g,-1 >16 g g \tieUp g~
      \arpBarre #-3 \stemUp g4
      \stemDown < a,-1 >16 a a a | }
  >>
  \bar "||"

                                %4
  <<
    { \stemUp < bis''-2-\RH #1 >16 < bis-\RH #3 > < bis-\RH #1 > \tieUp < bis-\RH #3 >~
      \arpBarre #-3 bis4
      \stemDown < cis,-2 >16 cis cis cis~
      \arpBarre #-2 \stemUp cis4 | } \\
    { \stemDown s4
      < f-2 >16 f f \tieUp f~
      \arpBarre #-3 \stemUp f4
      \stemDown < gis,-2 >16 gis gis gis~ | }
  >>
                                %5
  <<
    { \stemDown < dis-2 >16 dis dis dis~
      \arpBarre #-3 \stemUp dis4
      \stemDown bis16 bis bis \tieDown bis~
      \arpBarre #3 bis4 | } \\
    { \arpBarre #-3 \stemUp gis'4
      \stemUp < bis,-2 >16 bis bis bis
      s4
      \stemUp < dis-2 >16 dis dis dis~ | }
  >>
                                %6
  <<
    { \stemUp < gis-2 >16 gis gis \tieDown gis~
      \arpBarre #3 \stemDown gis4
      \stemUp < f'-2 >16 f f f~
      \arpBarre #3 \stemDown f4 |} \\
    { \arpBarre #3 \stemDown dis,4
      \stemUp < cis'-2 >16 cis cis cis~
      \arpBarre #2 \stemDown cis4
      \stemUp < bis'-2 >16 bis bis bis | }
  >>
  \bar "||"

                                %7
  <<
    { \stemUp < b,,-3-\RH #1 >16 < b-\RH #3 > < b-\RH #1 > \tieDown < b-\RH #3 >~
      \arpBarre #3 \stemDown b4
      \stemUp  < a'-3 >16 a a a~
      \arpBarre #3 \stemDown a4 | } \\
    { \stemUp s4
      < e-3 >16 e e e~
      \arpBarre #3 \stemDown e4
      \stemUp < d'-3 >16 d d d~ | }
  >>
                                %8
  <<
    { \stemUp < fis-3 >16 fis fis \tieDown fis~
      \arpBarre #3 \stemDown fis4
      \stemUp b16 b b \tieUp b~
      b4 | } \\
    { \arpBarre #2 \stemDown d,4
      \stemUp < b'-3 >16 b b b
      s4
      \stemDown < fis-3 >16 fis fis fis~ | }
  >>
                                %9
  <<
    { \stemDown < d-3 >16 d d d~
      \arpBarre #-3 \stemUp d4
      \stemDown < e,-3 >16 e e  \tieUp e~
      \arpBarre #-3 \stemUp e4 |} \\
    { \arpBarre #-2 \stemUp fis'4
      \stemDown < a,-3 >16 a a \tieUp a~
      \arpBarre #-3 \stemUp a4
      \stemDown < b,-3 >16 b b b | }
  >>
  \bar "||"

                                %10
  <<
    { \stemUp < c''-4-\RH #1 >16 < c-\RH #3 > < c-\RH #1 > \tieUp < c-\RH #3 >~
      \arpBarre #-3 c4
      \stemDown < dis,-4 >16 dis dis dis~
      \arpBarre #-4 \stemUp dis4 | } \\
    { \stemDown s4
      < g-4 >16 g g \tieUp g~
      \arpBarre #-3 \stemUp g4
      \stemDown < ais,-4 >16 ais ais ais~ | }
  >>
                                %11
  <<
    { \stemDown < f-4 >16 f f f~
      \arpBarre #-3 \stemUp f4
      \stemDown c16 c c \tieDown c~
      \arpBarre #3 c4 | } \\
    { \arpBarre #-3 \stemUp ais'4
      \stemUp < c,-4 >16 c c c
      s4
      \stemUp < f-4 >16 f f f~ | }
  >>
                                %12
  <<
    { \stemUp < ais-4 >16 ais ais \tieDown ais~
      \arpBarre #3 \stemDown ais4
      \stemUp < g'-4 >16 g g g~
      \arpBarre #3 \stemDown g4 |} \\
    { \arpBarre #3 \stemDown f,4
      \stemUp < dis'-4 >16 dis dis dis~
      \arpBarre #2 \stemDown dis4
      \stemUp < c'-4 >16 c c c | }
  >>
  \bar "|."
}

\score {
  \barreVPm
}