\version "2.24.0"
%% barre_IX.pa.ly
%% letzte Bearbeitung 2025-11-25

%% %% ************************************
%% %% Gitarrekram
#(define RH rightHandFinger)

%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})

%% %% Gitarrenkram Ende
%% %% ************************************

                                % und hier die Noten
barreIXPa = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

                                %1
  <<
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left)
      \stemUp < cis-1-\RH #1 >16^\markup "IX." < cis-\RH #4 > < cis-\RH #1 > \tieDown < cis-\RH #4 >~
      \arpBarre #3 \stemDown cis4
      \stemUp  < b'-1 >16 b b b~
      \arpBarre #3 \stemDown b4 | } \\
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left)
      \stemUp s4
      < fis-1 >16 fis fis fis~
      \arpBarre #3 \stemDown fis4
      \stemUp < e'-1 >16 e e e~ | }
  >>
                                %2
  <<
    { \stemUp < gis-1 >16 gis gis \tieDown gis~
      \arpBarre #3 \stemDown gis4
      \stemUp cis16 cis cis \tieUp cis~
      cis4 | } \\
    { \arpBarre #2 \stemDown e,4
      \stemUp < cis'-1 >16 cis cis cis
      s4
      \stemDown < gis-1 >16 gis gis gis~ | }
  >>
                                %3
  <<
    { \stemDown < e-1 >16 e e e~
      \arpBarre #-3 \stemUp e4
      \stemDown < fis,-1 >16 fis fis  \tieUp fis~
      \arpBarre #-3 \stemUp fis4 |} \\
    { \arpBarre #-2 \stemUp gis'4
      \stemDown < b,-1 >16 b b \tieUp b~
      \arpBarre #-3 \stemUp b4
      \stemDown < dis,-1 >16 dis dis dis | }
  >>
  \bar "||"

                                %4
  <<
    { \stemUp < d''-2-\RH #1 >16 < d-\RH #4 > < d-\RH #1 > \tieUp < d-\RH #4 >~
      \arpBarre #-3 d4
      \stemDown < f,-2 >16 f f f~
      \arpBarre #-2 \stemUp f4 | } \\
    { \stemDown s4
      < a-2 >16 a a \tieUp a~
      \arpBarre #-3 \stemUp a4
      \stemDown < c,-2 >16 c c c~ | }
  >>
                                %5
  <<
    { \stemDown < g-2 >16 g g g~
      \arpBarre #-3 \stemUp g4
      \stemDown d16 d d \tieDown d~
      \arpBarre #3 d4 | } \\
    { \arpBarre #-3 \stemUp c'4
      \stemDown < d,-2 >16 d d d
      s4
      \stemUp < g-2 >16 g g g~ | }
  >>
                                %6
  <<
    { \stemUp < c-2 >16 c c \tieDown c~
      \arpBarre #3 \stemDown c4
      \stemUp < a'-2 >16 a a a~
      \arpBarre #3 \stemDown a4 |} \\
    { \arpBarre #3 \stemDown g,4
      \stemUp < f'-2 >16 f f f~
      \arpBarre #2 \stemDown f4
      \stemUp < d'-2 >16 d d d | }
  >>
  \bar "||"

                                %7
  <<
    { \stemUp < dis,,-3-\RH #1 >16 < dis-\RH #4 > < dis-\RH #1 > \tieDown < dis-\RH #4 >~
      \arpBarre #3 \stemDown dis4
      \stemUp  < cis'-3 >16 cis cis cis~
      \arpBarre #3 \stemDown cis4 | } \\
    { \stemUp s4
      < gis-3 >16 gis gis gis~
      \arpBarre #3 \stemDown gis4
      \stemUp < fis'-3 >16 fis fis fis~ | }
  >>
                                %8
  <<
    { \stemUp < ais-3 >16 ais ais \tieDown ais~
      \arpBarre #3 \stemDown ais4
      \stemUp dis16 dis dis \tieUp dis~
      dis4 | } \\
    { \arpBarre #2 \stemDown fis,4
      \stemUp < dis'-3 >16 dis dis dis
      s4
      \stemDown < ais-3 >16 ais ais ais~ | }
  >>
                                %9
  <<
    { \stemDown < fis-3 >16 fis fis fis~
      \arpBarre #-3 \stemUp fis4
      \stemDown < gis,-3 >16 gis gis  \tieUp gis~
      \arpBarre #-3 \stemUp gis4 |} \\
    { \arpBarre #-2 \stemUp ais'4
      \stemDown < cis,-3 >16 cis cis \tieUp cis~
      \arpBarre #-3 \stemUp cis4
      \stemDown < dis,-3 >16 dis dis dis | }
  >>
  \bar "||"

                                %10
  <<
    { \stemUp < e''-4-\RH #1 >16 < e-\RH #4 > < e-\RH #1 > \tieUp < e-\RH #4 >~
      \arpBarre #-3 e4
      \stemDown < g,-4 >16 g g g~
      \arpBarre #-4 \stemUp g4 | } \\
    { \stemDown s4
      < b-4 >16 b b \tieUp b~
      \arpBarre #-3 \stemUp b4
      \stemDown < d,-4 >16 d d d~ | }
  >>
                                %11
  <<
    { \stemDown < a-4 >16 a a a~
      \arpBarre #-3 \stemUp a4
      \stemDown e16 e e \tieDown e~
      \arpBarre #3 e4 | } \\
    { \arpBarre #-3 \stemUp d'4
      \stemDown < e,-4 >16 e e e
      s4
      \stemUp < a-4 >16 a a a~ | }
  >>
                                %12
  <<
    { \stemUp < d-4 >16 d d \tieDown d~
      \arpBarre #3 \stemDown d4
      \stemUp < b'-4 >16 b b b~
      \arpBarre #3 \stemDown b4 |} \\
    { \arpBarre #3 \stemDown a,4
      \stemUp < g'-4 >16 g g g~
      \arpBarre #2 \stemDown g4
      \stemUp < e'-4 >16 e e e | }
  >>
  \bar "|."
}

\score {
  \barreIXPa
}