\version "2.24.0"
%% barre_III.pm.ly
%% letzte Bearbeitung 2025-11-26

%% %% ************************************
%% %% Gitarrekram
#(define RH rightHandFinger)

%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})

%% %% Gitarrenkram Ende
%% %% ************************************

barreIIIpm = \relative c'' {
  \key c \major
  \time 4/4
  \clef "treble_8"

                                %Einstellungen
  <<
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left)
    } \\
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left) }
  >>

                                %1
  <<
    { \stemUp < g-1-\RH #1 >16^\markup "III." < g-\RH #3 > < g-\RH #1 > \tieUp < g-\RH #3 >~
      \arpBarre #-3 g4
      \stemDown < ais,-1 >16 ais ais ais~
      \arpBarre #-2 \stemUp ais4 | } \\
    { \stemDown s4
      < d-1 >16 d d \tieUp d~
      \arpBarre #-3 \stemUp d4
      \stemDown < f,-1 >16 f f f~ | }
  >>
                                %2
  <<
    { \stemDown < c-1 >16 c c c~
      \arpBarre #-3 \stemUp c4
      \stemDown g16 g g \tieDown g~
      \arpBarre #3 g4 | } \\
    { \arpBarre #-3 \stemUp f'4
      \stemDown < g,-1 >16 g g g
      s4
      \stemUp < c-1 >16 c c c~ | }
  >>
                                %3
  <<
    { \stemUp < f-1 >16 f f \tieDown f~
      \arpBarre #3 \stemDown f4
      \stemUp < d'-1 >16 d d d~
      \arpBarre #3 \stemDown d4 |} \\
    { \arpBarre #3 \stemDown c,4
      \stemUp < ais'-1 >16 ais ais ais~
      \arpBarre #2 \stemDown ais4
      \stemUp < g'-1 >16 g g g | }
  >>
  \bar "||"

                                %4
  <<
    { \stemUp < gis,,-2-\RH #1 >16 < gis-\RH #3 > < gis-\RH #1 > \tieDown < gis-\RH #3 >~
      \arpBarre #3 \stemDown gis4
      \stemUp  < fis'-2 >16 fis fis fis~
      \arpBarre #3 \stemDown fis4 | } \\
    { \stemUp s4
      < cis-2 >16 cis cis cis~
      \arpBarre #3 \stemDown cis4
      \stemUp < b'-2 >16 b b b~ | }
  >>
                                %5
  <<
    { \stemUp < dis-2 >16 dis dis \tieDown dis~
      \arpBarre #3 \stemDown dis4
      \stemUp gis16 gis gis \tieUp gis~
      gis4 | } \\
    { \arpBarre #2 \stemDown b,4
      \stemUp < gis'-2 >16 gis gis gis
      s4
      \stemDown < dis-2 >16 dis dis \tieUp dis~ | }
  >>
                                %6
  <<
    { \stemDown < b-2 >16 b b b~
      \arpBarre #-3 \stemUp b4
      \stemDown < cis,-2 >16 cis cis  \tieUp cis~
      \arpBarre #-3 \stemUp cis4 |} \\
    { \arpBarre #-2 \stemUp dis'4
      \stemDown < fis,-2 >16 fis fis \tieUp fis~
      \arpBarre #-3 \stemUp fis4
      \stemDown < gis,-2 >16 gis gis gis | }
  >>
  \bar "||"

                                %7
  <<
    { \stemUp < a''-3-\RH #1 >16 < a-\RH #3 > < a-\RH #1 > \tieUp < a-\RH #3 >~
      \arpBarre #-3 a4
      \stemDown < c,-3 >16 c c c~
      \arpBarre #-3 \stemUp c4 | } \\
    { \stemDown s4
      < e-3 >16 e e \tieUp e~
      \arpBarre #-3 \stemUp e4
      \stemDown < g,-3 >16 g g g~ | }
  >>
                                %8
  <<
    { \stemDown < d-3 >16 d d d~
      \arpBarre #-3 \stemUp d4
      \stemDown a16 a a \tieDown a~
      \arpBarre #3 a4 | } \\
    { \arpBarre #-3 \stemUp g'4
      \stemDown < a,-3 >16 a a a
      s4
      \stemUp < d-3 >16 d d d~ | }
  >>
                                %9
  <<
    { \stemUp < g-3 >16 g g \tieDown g~
      \arpBarre #3 \stemDown g4
      \stemUp < e'-3 >16 e e e~
      \arpBarre #3 \stemDown e4 |} \\
    { \arpBarre #3 \stemDown d,4
      \stemUp < c'-3 >16 c c c~
      \arpBarre #2 \stemDown c4
      \stemUp < a'-3 >16 a a a | }
  >>
  \bar "||"

                                %10
  <<
    { \stemUp < ais,,-4-\RH #1 >16 < ais-\RH #3 > < ais-\RH #1 > \tieDown < ais-\RH #3 >~
      \arpBarre #3 \stemDown ais4
      \stemUp  < gis'-4 >16 gis gis gis~
      \arpBarre #3 \stemDown gis4 | } \\
    { \stemUp s4
      < dis-4 >16 dis dis dis~
      \arpBarre #3 \stemDown dis4
      \stemUp < cis'-4 >16 cis cis cis~ | }
  >>
                                %11
  <<
    { \stemUp < f-4 >16 f f \tieDown f~
      \arpBarre #3 \stemDown f4
      \stemUp ais16 ais ais \tieUp ais~
      ais4 | } \\
    { \arpBarre #2 \stemDown cis,4
      \stemUp < ais'-4 >16 ais ais ais
      s4
      \stemDown < f-4 >16 f f \tieUp f~ | }
  >>
                                %12
  <<
    { \stemDown < cis-4 >16 cis cis cis~
      \arpBarre #-3 \stemUp cis4
      \stemDown < dis,-4 >16 dis dis  \tieUp dis~
      \arpBarre #-3 \stemUp dis4 |} \\
    { \arpBarre #-2 \stemUp f'4
      \stemDown < gis,-4 >16 gis gis \tieUp gis~
      \arpBarre #-3 \stemUp gis4
      \stemDown < ais,-4 >16 ais ais ais | }
  >>
  \bar "|."
}

\score {
  \barreIIIpm
}