\version "2.24.0"
%% barre_I.pm.ly
%% letzte Bearbeitung 2025-11-26

%% %% ************************************
%% %% Gitarrekram
#(define RH rightHandFinger)

%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})

%% %% Gitarrenkram Ende
%% %% ************************************

                                % und hier die Noten
barreIPm = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

                                %Einstellungen
  <<
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left) } \\
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left) }
  >>

                                %1
  <<
    { \stemUp < f-1-\RH #1 >16^\markup "I." < f-\RH #3 > < f-\RH #1 > \tieDown < f-\RH #3 >~
      \arpBarre #3 \stemDown f4
      \stemUp  < es'-1 >16 es es es~
      \arpBarre #3 \stemDown es4 | } \\
    { \stemUp s4
      < bes-1 >16 bes bes bes~
      \arpBarre #3 \stemDown bes4
      \stemUp < as'-1 >16 as as as~ | }
  >>
                                %2
  <<
    { \stemUp < c-1 >16 c c \tieDown c~
      \arpBarre #3 \stemDown c4
      \stemUp f16 f f \tieUp f~
      f4 | } \\
    { \arpBarre #2 \stemDown as,4
      \stemUp < f'-1 >16 f f f
      s4
      \stemDown < c-1 >16 c c c~ | }
  >>
                                %3
  <<
    { \stemDown < as-1 >16 as as as~
      \arpBarre #-3 \stemUp as4
      \stemDown < bes,-1 >16 bes bes  \tieUp bes~
      \arpBarre #-3 \stemUp bes4 |} \\
    { \arpBarre #-2 \stemUp c'4
      \stemDown < es,-1 >16 es es \tieUp es~
      \arpBarre #-3 \stemUp es4
      \stemDown < f,-1 >16 f f f | }
  >>
  \bar "||"

                                %4
  <<
    { \stemUp < fis''-2-\RH #1 >16 < fis-\RH #3 > < fis-\RH #1 > \tieUp < fis-\RH #3 >~
      \arpBarre #-3 fis4
      \stemDown < a,-2 >16 a a a~
      \arpBarre #-2 \stemUp a4 | } \\
    { \stemDown s4
      < cis-2 >16 cis cis \tieUp cis~
      \arpBarre #-3 \stemUp cis4
      \stemDown < e,-2 >16 e e e~ | }
  >>
                                %5
  <<
    { \stemDown < b-2 >16 b b b~
      \arpBarre #-3 \stemUp b4
      \stemDown fis16 fis fis \tieDown fis~
      \arpBarre #3 fis4 | } \\
    { \arpBarre #-3 \stemUp e'4
      \stemUp < fis,-2 >16 fis fis fis
      s4
      \stemUp < b-2 >16 b b b~ | }
  >>
                                %6
  <<
    { \stemUp < e-2 >16 e e \tieDown e~
      \arpBarre #3 \stemDown e4
      \stemUp < cis'-2 >16 cis cis cis~
      \arpBarre #3 \stemDown cis4 |} \\
    { \arpBarre #3 \stemDown b,4
      \stemUp < a'-2 >16 a a a~
      \arpBarre #2 \stemDown a4
      \stemUp < fis'-2 >16 fis fis fis | }
  >>
  \bar "||"

                                %7
  <<
    { \stemUp < g,,-3-\RH #1 >16^\markup "I." < g-\RH #3 > < g-\RH #1 > \tieDown < g-\RH #3 >~
      \arpBarre #3 \stemDown g4
      \stemUp  < f'-3 >16 f f f~
      \arpBarre #3 \stemDown f4 | } \\
    { \stemUp s4
      < c-3 >16 c c c~
      \arpBarre #3 \stemDown c4
      \stemUp < bes'-3 >16 bes bes bes~ | }
  >>
                                %8
  <<
    { \stemUp < d-3 >16 d d \tieDown d~
      \arpBarre #3 \stemDown d4
      \stemUp g16 g g \tieUp g~
      g4 | } \\
    { \arpBarre #2 \stemDown bes,4
      \stemUp < g'-3 >16 g g g
      s4
      \stemDown < d-3 >16 d d d~ | }
  >>
                                %9
  <<
    { \stemDown < bes-3 >16 bes bes bes~
      \arpBarre #-3 \stemUp bes4
      \stemDown < c,-3 >16 c c  \tieUp c~
      \arpBarre #-3 \stemUp c4 |} \\
    { \arpBarre #-2 \stemUp d'4
      \stemDown < f,-3 >16 f f \tieUp f~
      \arpBarre #-3 \stemUp f4
      \stemDown < g,-3 >16 g g g | }
  >>
  \bar "||"

                                %10
  <<
    { \stemUp < gis''-4-\RH #1 >16 < gis-\RH #3 > < gis-\RH #1 > \tieUp < gis-\RH #3 >~
      \arpBarre #-3 gis4
      \stemDown < b,-4 >16 b b b~
      \arpBarre #-4 \stemUp b4 | } \\
    { \stemDown s4
      < dis-4 >16 dis dis \tieUp dis~
      \arpBarre #-3 \stemUp dis4
      \stemDown < fis,-4 >16 fis fis fis~ | }
  >>
                                %11
  <<
    { \stemDown < cis-4 >16 cis cis cis~
      \arpBarre #-3 \stemUp cis4
      \stemDown gis16 gis gis \tieDown gis~
      \arpBarre #3 gis4 | } \\
    { \arpBarre #-3 \stemUp fis'4
      \stemUp < gis,-4 >16 gis gis gis
      s4
      \stemUp < cis-4 >16 cis cis cis~ | }
  >>
                                %12
  <<
    { \stemUp < fis-4 >16 fis fis \tieDown fis~
      \arpBarre #3 \stemDown fis4
      \stemUp < dis'-4 >16 dis dis dis~
      \arpBarre #3 \stemDown dis4 |} \\
    { \arpBarre #3 \stemDown cis,4
      \stemUp < b'-4 >16 b b b~
      \arpBarre #2 \stemDown b4
      \stemUp < gis'-4 >16 gis gis gis | }
  >>
  \bar "|."
}

\score {
  \barreIPm
}