\version "2.24.0"
%% letzte Bearbeitung 2010-11-30

\paper{
  %% soll bewirken das wirklich nur der Musikschnipswel ausgegeben wird
  %% Aufruf erfolgt mit:
  %% lilypond -dbackend=eps -dno-gs-load-fonts -dinclude-eps-fonts --png test.ly
  indent=0\mm
%%  line-width=240\mm
  oddFooterMarkup=##f
  oddHeaderMarkup=##f
  bootTitleMarkup=##f
  scoreTitleMarkup=##f
}


%% ************************************
%% Kram für die Gitarre
#(define RH rightHandFinger)
ste = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "1" )))
stb = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "2" )))
stg = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "3" )))
std = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "4" )))
stA = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "5" )))
stE = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "6" )))

ASS = {
  \override Fingering.add-stem-support = ##t
  \override StringNumber.add-stem-support = ##t
  \override StrokeFinger.add-stem-support = ##t
}

fUL = {
  \ASS
  \set strokeFingerOrientations = #'(up)
  \set fingeringOrientations = #'(left)
}
fUR= {
  \ASS
  \set strokeFingerOrientations = #'(up)
  \set fingeringOrientations = #'(right)
}
fDL = {
  \ASS
  \set strokeFingerOrientations = #'(down)
  \set fingeringOrientations = #'(left)
}
fDR= {
  \ASS
  \set strokeFingerOrientations = #'(down)
  \set fingeringOrientations = #'(right)
}

sl = {
  \override NoteHead.style = #'slash
                                %  \override Stem.transparent = ##t
}

nsl = {
  \revert NoteHead.style
                                %  \revert Stem.transparent
}

%% ein- und ausschalten mit \startTextSpan b.z.w. \stopTextSpan
barre = #(define-music-function (str) (string?)
          #{
          \once \override Voice.TextSpanner.edge-text = 
          #(cons (format "C ~a" str) "")
          \once \override Voice.TextSpanner.direction = #1
          \once \override Voice.TextSpanner.edge-height = #'(0 . 0.5)
          \once \override Voice.TextSpanner.padding = #1 
          \once \override Voice.TextSpanner.enclose-bounds = #1
          #})

%% eigene Akkordbezeichnung in diesem Fall Cb10 also C 10-
chExceptionMusic =  {
                                %   <c f g bes>
                                %  <c e g d'>1-\markup { \super "9"}
                                %  <c e g bes d'>1-\markup { \super "7/9"}
                                %  <c ees g bes d'>1-\markup { "m" \super "7/9"}
  <c e g ees'>1-\markup { \super { \flat "10" } }
}

                                % add to existing exceptions.
chExceptions = #(append
                 (sequential-music-to-chord-exceptions chExceptionMusic #t)
                 ignatzekExceptions)


%% Gitarrenkram Ende
%% ************************************





% und hier die Noten
gita = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ".|:-|"
  %1
  < cis-4\6-\RH #1 >16(^\markup "IX." <dis-3 >8.)( < e-1 >4) \breathe
  < fis\5 >16( gis8.)( a4) \breathe
  |

  %2
  < b\4 >16( cis8.)( d4) \breathe
  < e\3 >16( fis8.)( g4) \breathe
  |

  %3
  < gis\2 >16( ais8.)( b4) \breathe
  < cis\1 >16( dis8.)( e4) \breathe
  |

  %4
  cis16( dis8.)( e4) \breathe
  gis,16( ais8.)( b4) \breathe
  |

  %5
  e,16( fis8.)( g4) \breathe
  b,16( cis8.)( d4) \breathe
  |

  %6
  fis,16( gis8.)( a4) \breathe
  cis,16( dis8.)( e4) \breathe
  |
  \bar ":..:"
}

gitb = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %7
  < cis-4\6-\RH #1 >4(^\markup "IX." <dis-3 >16)( < e-1 >8.) \breathe
  < fis\5 >4( gis16)( a8.) \breathe
  |
  %8
  < b\4 >4( cis16)( d8.) \breathe
  < es\3 >4( fis16)( g8.) \breathe
  |
  %9
  < gis\2 >4( ais16)( b8.) \breathe
  < cis\1 >4( dis16)( e8.) \breathe
  |

  %10
  cis4( dis16)( e8.) \breathe
  gis,4( ais16)( b8.) \breathe
  |
  %11
  e,4( fis16)( g8.) \breathe
  b,4( cis16)( d8.) \breathe
  |
  %12
  fis,4( gis16)( a8.) \breathe
  cis4( dis16)( e8.) \breathe
  |
  \bar ":..:"
}

gitc = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %13
  < cis-4\6-\RH #1 >16(\accent^\markup "IX." <dis-3 >16)( < e-1 >8) \breathe
  < fis\5 >16(\accent gis16)( a8) \breathe
  < b\4 >16(\accent cis16)( d8) \breathe
  < e\3 >16(\accent fis16)( g8) \breathe
  |
  %14
  < gis\2 >16(\accent ais16)( b8) \breathe
  < cis\1 >16(\accent dis16)( e8) \breathe
  < cis >16(\accent dis16)( e8) \breathe
  gis,16(\accent ais16)( b8) \breathe
  |
  %15
  e,16(\accent fis16)( g8) \breathe
  b,16(\accent cis16)( d8) \breathe
  fis,16(\accent gis16)( a8) \breathe
  cis,16(\accent dis16)( e8) \breathe
  |
  \bar "||"

  %16
  cis16( dis16)(\accent e8) \breathe
  fis16( gis16)(\accent a8) \breathe
  b16( cis16)(\accent d8) \breathe
  e16( fis16)(\accent g8) \breathe
  |
  %17
  gis16( ais16)(\accent b8) \breathe
  cis16( dis16)(\accent e8) \breathe
  cis16( dis16)(\accent e8) \breathe
  gis,16( ais16)(\accent b8) \breathe
  |
  %18
  e,16( fis16)(\accent g8) \breathe
  b,16( cis16)(\accent d8) \breathe
  fis,16( gis16)(\accent a8) \breathe
  cis,16( dis16)(\accent e8) \breathe
  |
  \bar "||"

  %19
  cis16( dis16)( e8)\accent \breathe
  fis16( gis16)( a8)\accent \breathe
  b16( cis16)( d8)\accent \breathe
  e16( fis16)( g8)\accent \breathe
  |
  %20
  gis16( ais16)( b8)\accent \breathe
  cis16( dis16)( e8)\accent \breathe
  cis16( dis16)( e8)\accent \breathe
  gis,16( ais16)( b8)\accent \breathe
  |
  %21
  e,16( fis16)( g8)\accent \breathe
  b,16( cis16)( d8)\accent \breathe
  fis,16( gis16)( a8)\accent \breathe
  cis,16( dis16)( e8)\accent \breathe
  |
  \bar ":..:"
}

gitd = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %22
  \tuplet 3/2 { < cis-4\6-\RH #1 >8(\accent^\markup "IX." < dis-3 >)( < e-1 >) }
  \tuplet 3/2 { < fis\5 >8(\accent gis)( a) } \breathe
  \tuplet 3/2 { < b\4 >8(\accent cis)( d) }
  \tuplet 3/2 { < e\3 >8(\accent fis)( g) } \breathe
  |
  %23
  \tuplet 3/2 { < gis\2 >8(\accent ais)( b) }
  \tuplet 3/2 { < cis\1 >8(\accent dis)( e) } \breathe
  \tuplet 3/2 { cis8(\accent dis)( e) }
  \tuplet 3/2 { gis,8(\accent ais)( b) } \breathe
  |
  %24
  \tuplet 3/2 { e,8(\accent fis)( g) }
  \tuplet 3/2 { b,8(\accent cis)( d) } \breathe
  \tuplet 3/2 { fis,8(\accent gis)( a) }
  \tuplet 3/2 { cis,8(\accent dis)( e) } \breathe
  |
  \bar "||"

  %25
  \tuplet 3/2 { cis8( dis)(\accent e) }
  \tuplet 3/2 { fis8( gis)(\accent a) } \breathe
  \tuplet 3/2 { b8( cis)(\accent d) }
  \tuplet 3/2 { e8( fis)(\accent g) } \breathe
  |
  %26
  \tuplet 3/2 { gis8( ais)(\accent a) }
  \tuplet 3/2 { cis8( dis)(\accent e) } \breathe
  \tuplet 3/2 { cis8( dis)(\accent e) }
  \tuplet 3/2 { gis,8( ais)(\accent b) } \breathe
  |
  %27
  \tuplet 3/2 { e,8( fis)(\accent g) }
  \tuplet 3/2 { b,8( cis)(\accent d) } \breathe
  \tuplet 3/2 { fis,8( gis)(\accent a) }
  \tuplet 3/2 { cis,8( dis)(\accent e) } \breathe
  |
  \bar "||"

  %28
  \tuplet 3/2 { cis8( dis)( e)\accent }
  \tuplet 3/2 { fis8( gis)( a)\accent } \breathe
  \tuplet 3/2 { b8( cis)( d)\accent }
  \tuplet 3/2 { e8( fis)( g)\accent } \breathe
  |
  %29
  \tuplet 3/2 { gis8( ais)( b)\accent }
  \tuplet 3/2 { cis8( dis)( e)\accent } \breathe
  \tuplet 3/2 { cis8( dis)( e)\accent }
  \tuplet 3/2 { gis,8( ais)( b)\accent } \breathe
  |
  %30
  \tuplet 3/2 { e,8( fis)( g)\accent }
  \tuplet 3/2 { b,8( cis)( d)\accent } \breathe
  \tuplet 3/2 { fis,8( gis)( a)\accent }
  \tuplet 3/2 { cis,8( dis)( e)\accent } \breathe
  |
  \bar ":..:"
}

gite = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %31
  \tuplet 3/2 { < cis-4\6-\RH #1 >8(\accent^\markup "IX." <dis-3 >)( < e-1 >) }
  \tuplet 3/2 { < fis\5 >8(\accent gis)( a) }
  \tuplet 3/2 { < b\4 >8(\accent cis)( d) } \breathe
  \tuplet 3/2 { < e\3 >8(\accent fis)( g) }
  |
  %32
  \tuplet 3/2 { < gis\2 >8(\accent ais)( b) }
  \tuplet 3/2 { < cis\1 >8(\accent dis)( e) } \breathe
  \tuplet 3/2 { cis8(\accent dis)( e) }
  \tuplet 3/2 { gis,8(\accent ais)( b) }
  |
  %33
  \tuplet 3/2 { e,8(\accent fis)( g) } \breathe
  \tuplet 3/2 { b,8(\accent cis)( d) }
  \tuplet 3/2 { fis,8(\accent fis)( g) }
  \tuplet 3/2 { cis,8(\accent dis)( e) } \breathe
  |
  \bar "||"

  %34
  \tuplet 3/2 { cis8( dis)(\accent e) }
  \tuplet 3/2 { fis8( gis)(\accent a) }
  \tuplet 3/2 { b8( cis)(\accent d) } \breathe
  \tuplet 3/2 { e8( fis)(\accent g) }
  |
  %35
  \tuplet 3/2 { gis8( ais)(\accent b) }
  \tuplet 3/2 { cis8( dis)(\accent e) } \breathe
  \tuplet 3/2 { cis8( dis)(\accent e) }
  \tuplet 3/2 { gis,8( ais)(\accent b) }
  |
  %36
  \tuplet 3/2 { e,8( fis)(\accent g) } \breathe
  \tuplet 3/2 { b,8( cis)(\accent d) }
  \tuplet 3/2 { fis,8( gis)(\accent a) }
  \tuplet 3/2 { cis,8( dis)(\accent e) } \breathe
  |
  \bar "||"

  %37
  \tuplet 3/2 { cis8( dis)( e)\accent }
  \tuplet 3/2 { fis8( gis)( a)\accent }
  \tuplet 3/2 { b8( cis)( d)\accent } \breathe
  \tuplet 3/2 { e8( fis)( g)\accent }
  |
  %38
  \tuplet 3/2 { gis8( ais)( b)\accent }
  \tuplet 3/2 { cis8( dis)( e)\accent } \breathe
  \tuplet 3/2 { cis8( dis)( e)\accent }
  \tuplet 3/2 { gis,8( ais)( b)\accent }
  |
  %39
  \tuplet 3/2 { e,8( fis)( g)\accent } \breathe
  \tuplet 3/2 { b,8( cis)( d)\accent }
  \tuplet 3/2 { fis,8( gis)( a)\accent }
  \tuplet 3/2 { cis,8( dis)( e)\accent } \breathe
  |
  \bar ":..:"
}

gitf = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %40
  \tuplet 3/2 { < cis-4\6-\RH #1 >8(\accent^\markup "IX." <dis-3 >)( < e-1 >) }
  \tuplet 3/2 { < fis\5 >8(\accent gis)( a) }
  \tuplet 3/2 { < b\4 >8(\accent cis)( d) } \breathe
  \tuplet 3/2 { < e\3 >8(\accent fis)( g) }
  |
  %41
  \tuplet 3/2 { < gis\2 >8(\accent ais)( b) }
  \tuplet 3/2 { < cis\1 >8(\accent dis)( e) } \breathe
  \tuplet 3/2 { cis8(\accent dis)( e) }
  \tuplet 3/2 { gis,8(\accent ais)( b) }
  |
  %42
  \tuplet 3/2 { e,8(\accent fis)( g) } \breathe
  \tuplet 3/2 { b,8(\accent d)( cis) }
  \tuplet 3/2 { fis,8(\accent gis)( a) }
  \tuplet 3/2 { cis,8(\accent dis)( e) } \breathe
  |
  \bar "||"

  %43
  \tuplet 3/2 { cis8( dis)(\accent e) }
  \tuplet 3/2 { fis8( gis)(\accent a) }
  \tuplet 3/2 { b8( cis)(\accent d) } \breathe
  \tuplet 3/2 { e8( fis)(\accent g) }
  |
  %44
  \tuplet 3/2 { gis8( ais)(\accent b) }
  \tuplet 3/2 { cis8( dis)(\accent e) } \breathe
  \tuplet 3/2 { cis8( dis)(\accent e) }
  \tuplet 3/2 { gis,8( ais)(\accent b) }
  |
  %45
  \tuplet 3/2 { e,8( fis)(\accent g) } \breathe
  \tuplet 3/2 { b,8( cis)(\accent d) }
  \tuplet 3/2 { fis,8( gis)(\accent a) }
  \tuplet 3/2 { cis,8( dis)(\accent e) } \breathe
  |
  \bar "||"

  %46
  \tuplet 3/2 { cis8( dis)( e)\accent }
  \tuplet 3/2 { fis8( gis)( a)\accent }
  \tuplet 3/2 { b8( cis)( d)\accent } \breathe
  \tuplet 3/2 { e8( fis)( g)\accent }
  |
  %47
  \tuplet 3/2 { gis8( ais)( b)\accent }
  \tuplet 3/2 { cis8( dis)( e)\accent } \breathe
  \tuplet 3/2 { cis8( dis)( e)\accent }
  \tuplet 3/2 { gis,8( ais)( b)\accent }
  |
  %48
  \tuplet 3/2 { e,8( fis)( g)\accent } \breathe
  \tuplet 3/2 { b,8( cis)( d)\accent }
  \tuplet 3/2 { fis,8( gis)( a)\accent }
  \tuplet 3/2 { cis,8( dis)( e)\accent } \breathe
  |
  \bar ":..:"
}

gitg = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %49
  \tuplet 3/2 { < cis-4\6-\RH #1 >8(\accent^\markup "IX." <dis-3 >)( < e-1 >) }
  \tuplet 3/2 { < fis\5 >8(\accent gis)( a) }
  \tuplet 3/2 { < b\4 >8(\accent cis)( d) }
  \tuplet 3/2 { < e\3 >8(\accent fis)( g) }
  |
  %50
  \tuplet 3/2 { < gis\2 >8(\accent ais)( b) }
  \tuplet 3/2 { < cis\1 >8(\accent dis)( e) } \breathe
  \tuplet 3/2 { cis8(\accent dis)( e) }
  \tuplet 3/2 { gis,8(\accent ais)( b) }
  |
  %51
  \tuplet 3/2 { e,8(\accent fis)( g) }
  \tuplet 3/2 { b,8(\accent cis)( d) }
  \tuplet 3/2 { fis,8(\accent gis)( a) }
  \tuplet 3/2 { cis,8(\accent dis)( e) } \breathe
  |
  \bar "||"

  %52
  \tuplet 3/2 { cis8( dis)(\accent e) }
  \tuplet 3/2 { fis8( gis)(\accent a) }
  \tuplet 3/2 { b8( cis)(\accent d) }
  \tuplet 3/2 { e8( fis)(\accent g) }
  |
  %53
  \tuplet 3/2 { gis8( ais)(\accent b) }
  \tuplet 3/2 { cis8( dis)(\accent e) } \breathe
  \tuplet 3/2 { cis8( dis)(\accent e) }
  \tuplet 3/2 { gis,8( ais)(\accent b) }
  |
  %54
  \tuplet 3/2 { e,8( fis)(\accent g) }
  \tuplet 3/2 { b,8( cis)(\accent d) }
  \tuplet 3/2 { fis,8( gis)(\accent a) }
  \tuplet 3/2 { cis,8( dis)(\accent e) } \breathe
  |
  \bar "||"

  %55
  \tuplet 3/2 { cis8( dis)( e)\accent }
  \tuplet 3/2 { fis8( gis)( a)\accent }
  \tuplet 3/2 { b8( cis)( d)\accent }
  \tuplet 3/2 { e8( fis)( g)\accent }
  |
  %56
  \tuplet 3/2 { gis8( ais)( b)\accent }
  \tuplet 3/2 { cis8( dis)( e)\accent } \breathe
  \tuplet 3/2 { cis8( dis)( e)\accent }
  \tuplet 3/2 { gis,8( ais)( b)\accent }
  |
  %57
  \tuplet 3/2 { e,8( fis)( g)\accent }
  \tuplet 3/2 { b,8( cis)( d)\accent }
  \tuplet 3/2 { fis,8( gis)( a)\accent }
  \tuplet 3/2 { cis,8( dis)( e)\accent } \breathe
  |
  \bar ":..:"
}


#(set-global-staff-size 15)
\book {
  \score {
    {
      \gita
      \break
      \gitb
      \break
      \gitc
      \break
      \gitd
      \break
      \gite
      \break
      \gitf
      \break
      \gitg
    }
  }
}

\book {
  \score {
    \gita
    \layout {
      \context {
        \Score
        \remove "Bar_number_engraver"
      }
    }
  }
}

\book {
  \score {
    \gitb
    \layout {
      \context {
        \Score
        \remove "Bar_number_engraver"
      }
    }
  }
}

\book {
  \score {
    \gitc
    \layout {
      \context {
        \Score
        \remove "Bar_number_engraver"
      }
    }
  }
}

\book {
  \score {
    \gitd
    \layout {
      \context {
        \Score
        \remove "Bar_number_engraver"
      }
    }
  }
}

\book {
  \score {
    \gite
    \layout {
      \context {
        \Score
        \remove "Bar_number_engraver"
      }
    }
  }
}

\book {
  \score {
    \gitf
    \layout {
      \context {
        \Score
        \remove "Bar_number_engraver"
      }
    }
  }
}

\book {
  \score {
    \gitg
    \layout {
      \context {
        \Score
        \remove "Bar_number_engraver"
      }
    }
  }
}
