\version "2.24.0"
%% legato-20101130.ly
%% letzte Bearbeitung 2025-12-06

%% %% ************************************
%% %% Gitarrekram
#(define RH rightHandFinger)
ste = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "1" )))
stb = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "2" )))
stg = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "3" )))
std = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "4" )))
stA = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "5" )))
stE = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "6" )))

ASS = {
  \override Fingering.add-stem-support = ##t
  \override StringNumber.add-stem-support = ##t
  \override StrokeFinger.add-stem-support = ##t
}

fUL = {
  \ASS
  \set strokeFingerOrientations = #'(up)
  \set fingeringOrientations = #'(left)
}

fDL = {
  \ASS
  \set strokeFingerOrientations = #'(down)
  \set fingeringOrientations = #'(left)
}

%% %% Gitarrenkram Ende
%% %% ************************************

% und hier die Noten
gita = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ".|:-|"
  %1
  < c-4\6-\RH #1 >16(^\markup "V." < b-3 >8.)( < a-1 >4) \breathe
  < f'\5 >16( e8.)( d4) \breathe
  |

  %2
  < bes'\4 >16( a8.)( g4) \breathe
  < es'\3 >16( d8.)( c4) \breathe
  |

  %3
  < g'\2 >16( fis8.)( e4) \breathe
  < c'\1 >16( b8.)( a4) \breathe
  |

  %4
  c16( b8.)( a4) \breathe
  g16( fis8.)( e4) \breathe
  |

  %5
  es16( d8.)( c4) \breathe
  bes16( a8.)( g4) \breathe
  |

  %6
  f16( e8.)( d4) \breathe
  c16( b8.)( a4) \breathe
  |
  \bar ":..:"
}

gitb = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %7
  < c-4\6-\RH #1 >4(^\markup "V." < b-3 >16)( < a-1 >8.) \breathe
  < f'\5 >4( e16)( d8.) \breathe
  |
  %8
  < bes'\4 >4( a16)( g8.) \breathe
  < es'\3 >4( d16)( c8.) \breathe
  |
  %9
  < g'\2 >4( fis16)( e8.) \breathe
  < c'\1 >4( b16)( a8.) \breathe
  |

  %10
  < c >4( b16)( a8.) \breathe
  < g >4( fis16)( e8.) \breathe
  |
  %11
  es4( d16)( c8.) \breathe
  bes4( a16)( g8.) \breathe
  |
  %12
  f4( e16)( d8.) \breathe
  c4( b16)( a8.) \breathe
  |
  \bar ":..:"
}

gitcA = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %1
  < c'-4\6-\RH #1 >16(\accent^\markup "V." < b-3 >16)( < a-1 >8) \breathe
  < f'\5 >16(\accent e16)( d8) \breathe
  < bes'\4 >16(\accent a16)( g8) \breathe
  < es'\3 >16(\accent d16)( c8) \breathe
  |
  %2
  < g'\2 >16(\accent fis16)( e8) \breathe
  < c'\1 >16(\accent b16)( a8) \breathe
  < c >16(\accent b16)( a8) \breathe
  < g >16(\accent fis16)( e8) \breathe
  |
  %3
  es16(\accent d16)( c8) \breathe
  bes16(\accent a16)( g8) \breathe
  f16(\accent e16)( d8) \breathe
  c16(\accent b16)( a8) \breathe
  |
  \bar "||"

  %4
  c16( b16)(\accent a8) \breathe
  f'16( e16)(\accent d8) \breathe
  bes'16( a16)(\accent g8) \breathe
  es'16( d16)(\accent c8) \breathe
  |
}

gitcB = \relative c' {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #5
  \fDL
  %5
  g'16( fis16)(\accent e8) \breathe
  c'16( b16)(\accent a8) \breathe
  c16( b16)(\accent a8) \breathe
  g16( fis16)(\accent e8) \breathe
  |
  %6
  es16( d16)(\accent c8) \breathe
  bes16( a16)(\accent g8) \breathe
  f16( e16)(\accent d8) \breathe
  c16( b16)(\accent a8) \breathe
  |
  \bar "||"

  %7
  c16( b16)( a8)\accent \breathe
  f'16( e16)( d8)\accent \breathe
  bes'16( a16)( g8)\accent \breathe
  es'16( d16)( c8)\accent \breathe
  |
  %8
  g'16( fis16)( e8)\accent \breathe
  c'16( b16)( a8)\accent \breathe
  c16( b16)( a8)\accent \breathe
  g16( fis16)( e8)\accent \breathe
  |
  %9
  es16( d16)( c8)\accent \breathe
  bes16( a16)( g8)\accent \breathe
  f16( e16)( d8)\accent \breathe
  c16( b16)( a8)\accent \breathe
  |
  \bar ":..:"
}

gitd = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %22
  \tuplet 3/2 { < c-4\6-\RH #1 >8(\accent^\markup "V." < b-3 >)( < a-1 >) }
  \tuplet 3/2 { < f'\5 >8(\accent e)( d) } \breathe
  \tuplet 3/2 { < bes'\4 >8(\accent a)( g) }
  \tuplet 3/2 { < es'\3 >8(\accent d)( c) } \breathe
  |
  %23
  \tuplet 3/2 { < g'\2 >8(\accent fis)( e) }
  \tuplet 3/2 { < c'\1 >8(\accent b)( a) } \breathe
  \tuplet 3/2 { c8(\accent b)( a) }
  \tuplet 3/2 { g8(\accent fis)( e) } \breathe
  |
  %24
  \tuplet 3/2 { es8(\accent d)( c) }
  \tuplet 3/2 { bes8(\accent a)( g) } \breathe
  \tuplet 3/2 { f8(\accent e)( d) }
  \tuplet 3/2 { c8(\accent b)( a) } \breathe
  |
  \bar "||"

  %25
  \tuplet 3/2 { c8( b)(\accent a) }
  \tuplet 3/2 { f'8( e)(\accent d) } \breathe
  \tuplet 3/2 { bes'8( a)(\accent g) }
  \tuplet 3/2 { es'8( d)(\accent c) } \breathe
  |
  %26
  \tuplet 3/2 { g'8( fis)(\accent e) }
  \tuplet 3/2 { c'8( b)(\accent a) } \breathe
  \tuplet 3/2 { c8( b)(\accent a) }
  \tuplet 3/2 { g8( fis)(\accent e) } \breathe
  |
  %27
  \tuplet 3/2 { es8( d)(\accent c) }
  \tuplet 3/2 { bes8( a)(\accent g) } \breathe
  \tuplet 3/2 { f8( e)(\accent d) }
  \tuplet 3/2 { c8( b)(\accent a) } \breathe
  |
  \bar "||"

  %28
  \tuplet 3/2 { c8( b)( a)\accent }
  \tuplet 3/2 { f'8( e)( d)\accent } \breathe
  \tuplet 3/2 { bes'8( a)( g)\accent }
  \tuplet 3/2 { es'8( d)( c)\accent } \breathe
  |
  %29
  \tuplet 3/2 { g'8( fis)( e)\accent }
  \tuplet 3/2 { c'8( b)( a)\accent } \breathe
  \tuplet 3/2 { c8( b)( a)\accent }
  \tuplet 3/2 { g8( fis)( e)\accent } \breathe
  |
  %30
  \tuplet 3/2 { es8( d)( c)\accent }
  \tuplet 3/2 { bes8( a)( g)\accent } \breathe
  \tuplet 3/2 { f8( e)( d)\accent }
  \tuplet 3/2 { c8( b)( a)\accent } \breathe
  |
  \bar ":..:"
}

gite = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %31
  \tuplet 3/2 { < c-4\6-\RH #1 >8(\accent^\markup "V." < b-3 >)( < a-1 >) }
  \tuplet 3/2 { < f'\5 >8(\accent e)( d) }
  \tuplet 3/2 { < bes'\4 >8(\accent a)( g) } \breathe
  \tuplet 3/2 { < es'\3 >8(\accent d)( c) }
  |
  %32
  \tuplet 3/2 { < g'\2 >8(\accent fis)( e) }
  \tuplet 3/2 { < c'\1 >8(\accent b)( a) } \breathe
  \tuplet 3/2 { c8(\accent b)( a) }
  \tuplet 3/2 { g8(\accent fis)( e) }
  |
  %33
  \tuplet 3/2 { es8(\accent d)( c) } \breathe
  \tuplet 3/2 { bes8(\accent a)( g) }
  \tuplet 3/2 { f8(\accent e)( d) }
  \tuplet 3/2 { c8(\accent b)( a) } \breathe
  |
  \bar "||"

  %34
  \tuplet 3/2 { c8( b)(\accent a) }
  \tuplet 3/2 { f'8( e)(\accent d) }
  \tuplet 3/2 { bes'8( a)(\accent g) } \breathe
  \tuplet 3/2 { es'8( d)(\accent c) }
  |
  %35
  \tuplet 3/2 { g'8( fis)(\accent e) }
  \tuplet 3/2 { c'8( b)(\accent a) } \breathe
  \tuplet 3/2 { c8( b)(\accent a) }
  \tuplet 3/2 { g8( fis)(\accent e) }
  |
  %36
  \tuplet 3/2 { es8( d)(\accent c) } \breathe
  \tuplet 3/2 { bes8( a)(\accent g) }
  \tuplet 3/2 { f8( e)(\accent d) }
  \tuplet 3/2 { c8( b)(\accent a) } \breathe
  |
  \bar "||"

  %37
  \tuplet 3/2 { c8( b)( a)\accent }
  \tuplet 3/2 { f'8( e)( d)\accent }
  \tuplet 3/2 { bes'8( a)( g)\accent } \breathe
  \tuplet 3/2 { es'8( d)( c)\accent }
  |
  %38
  \tuplet 3/2 { g'8( fis)( e)\accent }
  \tuplet 3/2 { c'8( b)( a)\accent } \breathe
  \tuplet 3/2 { c8( b)( a)\accent }
  \tuplet 3/2 { g8( fis)( e)\accent }
  |
  %39
  \tuplet 3/2 { es8( d)( c)\accent } \breathe
  \tuplet 3/2 { bes8( a)( g)\accent }
  \tuplet 3/2 { f8( e)( d)\accent }
  \tuplet 3/2 { c8( b)( a)\accent } \breathe
  |
  \bar ":..:"
}

gitf = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %40
  \tuplet 3/2 { < c-4\6-\RH #1 >8(\accent^\markup "V." < b-3 >)( < a-1 >) }
  \tuplet 3/2 { < f'\5 >8(\accent e)( d) }
  \tuplet 3/2 { < bes'\4 >8(\accent a)( g) } \breathe
  \tuplet 3/2 { < es'\3 >8(\accent d)( c) }
  |
  %41
  \tuplet 3/2 { < g'\2 >8(\accent fis)( e) }
  \tuplet 3/2 { < c'\1 >8(\accent b)( a) } \breathe
  \tuplet 3/2 { c8(\accent b)( a) }
  \tuplet 3/2 { g8(\accent fis)( e) }
  |
  %42
  \tuplet 3/2 { es8(\accent d)( c) } \breathe
  \tuplet 3/2 { bes8(\accent g)( a) }
  \tuplet 3/2 { f8(\accent e)( d) }
  \tuplet 3/2 { c8(\accent b)( a) } \breathe
  |
  \bar "||"

  %43
  \tuplet 3/2 { c8( b)(\accent a) }
  \tuplet 3/2 { f'8( e)(\accent d) }
  \tuplet 3/2 { bes'8( a)(\accent g) } \breathe
  \tuplet 3/2 { es'8( d)(\accent c) }
  |
  %44
  \tuplet 3/2 { g'8( fis)(\accent e) }
  \tuplet 3/2 { c'8( b)(\accent a) } \breathe
  \tuplet 3/2 { c8( b)(\accent a) }
  \tuplet 3/2 { g8( fis)(\accent e) }
  |
  %45
  \tuplet 3/2 { es8( d)(\accent c) } \breathe
  \tuplet 3/2 { bes8( a)(\accent g) }
  \tuplet 3/2 { f8( e)(\accent d) }
  \tuplet 3/2 { c8( b)(\accent a) } \breathe
  |
  \bar "||"

  %46
  \tuplet 3/2 { c8( b)( a)\accent }
  \tuplet 3/2 { f'8( e)( d)\accent }
  \tuplet 3/2 { bes'8( a)( g)\accent } \breathe
  \tuplet 3/2 { es'8( d)( c)\accent }
  |
  %47
  \tuplet 3/2 { g'8( fis)( e)\accent }
  \tuplet 3/2 { c'8( b)( a)\accent } \breathe
  \tuplet 3/2 { c8( b)( a)\accent }
  \tuplet 3/2 { g8( fis)( e)\accent }
  |
  %48
  \tuplet 3/2 { es8( d)( c)\accent } \breathe
  \tuplet 3/2 { bes8( a)( g)\accent }
  \tuplet 3/2 { f8( e)( d)\accent }
  \tuplet 3/2 { c8( b)( a)\accent } \breathe
  |
  \bar ":..:"
}

gitg = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %49
  \tuplet 3/2 { < c-4\6-\RH #1 >8(\accent^\markup "V." < b-3 >)( < a-1 >) }
  \tuplet 3/2 { < f'\5 >8(\accent e)( d) }
  \tuplet 3/2 { < bes'\4 >8(\accent a)( g) }
  \tuplet 3/2 { < es'\3 >8(\accent d)( c) }
  |
  %50
  \tuplet 3/2 { < g'\2 >8(\accent fis)( e) }
  \tuplet 3/2 { < c'\1 >8(\accent b)( a) } \breathe
  \tuplet 3/2 { c8(\accent b)( a) }
  \tuplet 3/2 { g8(\accent fis)( e) }
  |
  %51
  \tuplet 3/2 { es8(\accent d)( c) }
  \tuplet 3/2 { bes8(\accent a)( g) }
  \tuplet 3/2 { f8(\accent e)( d) }
  \tuplet 3/2 { c8(\accent b)( a) } \breathe
  |
  \bar "||"

  %52
  \tuplet 3/2 { c8( b)(\accent a) }
  \tuplet 3/2 { f'8( e)(\accent d) }
  \tuplet 3/2 { bes'8( a)(\accent g) }
  \tuplet 3/2 { es'8( d)(\accent c) }
  |
  %53
  \tuplet 3/2 { g'8( fis)(\accent e) }
  \tuplet 3/2 { c'8( b)(\accent a) } \breathe
  \tuplet 3/2 { c8( b)(\accent a) }
  \tuplet 3/2 { g8( fis)(\accent e) }
  |
  %54
  \tuplet 3/2 { es8( d)(\accent c) }
  \tuplet 3/2 { bes8( a)(\accent g) }
  \tuplet 3/2 { f8( e)(\accent d) }
  \tuplet 3/2 { c8( b)(\accent a) } \breathe
  |
  \bar "||"

  %55
  \tuplet 3/2 { c8( b)( a)\accent }
  \tuplet 3/2 { f'8( e)( d)\accent }
  \tuplet 3/2 { bes'8( a)( g)\accent }
  \tuplet 3/2 { es'8( d)( c)\accent }
  |
  %56
  \tuplet 3/2 { g'8( fis)( e)\accent }
  \tuplet 3/2 { c'8( b)( a)\accent } \breathe
  \tuplet 3/2 { c8( b)( a)\accent }
  \tuplet 3/2 { g8( fis)( e)\accent }
  |
  %57
  \tuplet 3/2 { es8( d)( c)\accent }
  \tuplet 3/2 { bes8( a)( g)\accent }
  \tuplet 3/2 { f8( e)( d)\accent }
  \tuplet 3/2 { c8( b)( a)\accent } \breathe
  |
  \bar ":..:"
}


% %#(set-global-staff-size 15)
% \book {
%   \score {
%     {
%       \gita
%       \break
%       \gitb
%       \break
%       \gitc
%       \break
%       \gitd
%       \break
%       \gite
%       \break
%       \gitf
%       \break
%       \gitg
%     }
%   }
% }

#(define output-suffix "1")
\book {
  \score {
    \gita
  }
}

#(define output-suffix "2")
\book {
  \score {
    \gitb
  }
}

#(define output-suffix "3a")
\book {
  \score {
    \gitcA
  }
}

#(define output-suffix "3b")
\book {
  \paper { indent = 0.0 }
  \score {
    \gitcB
  }
}

#(define output-suffix "4")
\book {
  \score {
    \gitd
  }
}

#(define output-suffix "5")
\book {
  \score {
    \gite
  }
}

#(define output-suffix "6")
\book {
  \score {
    \gitf
  }
}

#(define output-suffix "7")
\book {
  \score {
    \gitg
  }
}
