\version "2.24.0"
%% barre_XI.pm.ly
%% letzte Bearbeitung 2025-11-27

%% %% ************************************
%% %% Gitarrekram
#(define RH rightHandFinger)

%% Vertikale
%% Verwendung \arpBarre #3
%% Startpunkt ist der folgende Ton
%% positive Zahlen = Länge nach oben
%% negative Zahlen = Länge nach unten
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})

%% %% Gitarrenkram Ende
%% %% ************************************

barreXIpm = \relative c'' {
  \key c \major
  \time 4/4
  \clef "treble_8"

                                %Einstellungen
  <<
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left)
    } \\
    { \override StrokeFinger.avoid-slur = #'outside
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(down)
      \set fingeringOrientations = #'(left) }
  >>

                                %1
  <<
    { \stemUp < dis-1-\RH #1 >16^\markup "XI." < dis-\RH #3 > < dis-\RH #1 > \tieUp < dis-\RH #3 >~
      \arpBarre #-3 dis4
      \stemDown < fis,-1 >16 fis fis fis~
      \arpBarre #-2 \stemUp fis4 | } \\
    { \stemDown s4
      <  ais-1 >16  ais  ais \tieUp  ais~
      \arpBarre #-3 \stemUp  ais4
      \stemDown < cis,-1 >16 cis cis cis~ | }
  >>
                                %2
  <<
    { \stemDown < gis-1 >16 gis gis gis~
      \arpBarre #-3 \stemUp gis4
      \stemDown dis16 dis dis \tieDown dis~
      \arpBarre #3 dis4 | } \\
    { \arpBarre #-3 \stemUp cis'4
      \stemDown < dis,-1 >16 dis dis dis
      s4
      \stemUp < gis-1 >16 gis gis gis~ | }
  >>
                                %3
  <<
    { \stemUp < cis-1 >16 cis cis \tieDown cis~
      \arpBarre #3 \stemDown cis4
      \stemUp <  ais'-1 >16  ais  ais  ais~
      \arpBarre #3 \stemDown  ais4 |} \\
    { \arpBarre #3 \stemDown gis,4
      \stemUp < fis'-1 >16 fis fis fis~
      \arpBarre #2 \stemDown fis4
      \stemUp < dis'-1 >16 dis dis dis | }
  >>
  \bar "||"

                                %4
  <<
    { \stemUp < e,,-2-\RH #1 >16 < e-\RH #3 > < e-\RH #1 > \tieDown < e-\RH #3 >~
      \arpBarre #3 \stemDown e4
      \stemUp  < d'-2 >16 d d d~
      \arpBarre #3 \stemDown d4 | } \\
    { \stemUp s4
      < a-2 >16 a a a~
      \arpBarre #3 \stemDown a4
      \stemUp < g'-2 >16 g g g~ | }
  >>
                                %5
  <<
    { \stemUp < b-2 >16 b b \tieDown b~
      \arpBarre #3 \stemDown b4
      \stemUp e16 e e \tieUp e~
      e4 | } \\
    { \arpBarre #2 \stemDown g,4
      \stemUp < e'-2 >16 e e e
      s4
      \stemDown < b-2 >16 b b \tieUp b~ | }
  >>
                                %6
  <<
    { \stemDown < g-2 >16 g g g~
      \arpBarre #-3 \stemUp g4
      \stemDown < a,-2 >16 a a  \tieUp a~
      \arpBarre #-3 \stemUp a4 |} \\
    { \arpBarre #-2 \stemUp b'4
      \stemDown < d,-2 >16 d d \tieUp d~
      \arpBarre #-3 \stemUp d4
      \stemDown < e,-2 >16 e e e | }
  >>
  \bar "||"

                                %7
  <<
    { \stemUp < f''-3-\RH #1 >16 < f-\RH #3 > < f-\RH #1 > \tieUp < f-\RH #3 >~
      \arpBarre #-3 f4
      \stemDown < gis,-3 >16 gis gis gis~
      \arpBarre #-3 \stemUp gis4 | } \\
    { \stemDown s4
      < c-3 >16 c c \tieUp c~
      \arpBarre #-3 \stemUp c4
      \stemDown < dis,-3 >16 dis dis dis~ | }
  >>
                                %8
  <<
    { \stemDown < ais-3 >16 ais ais ais~
      \arpBarre #-3 \stemUp ais4
      \stemDown f16 f f \tieDown f~
      \arpBarre #3 f4 | } \\
    { \arpBarre #-3 \stemUp dis'4
      \stemDown < f,-3 >16 f f f
      s4
      \stemUp < ais-3 >16 ais ais ais~ | }
  >>
                                %9
  <<
    { \stemUp < dis-3 >16 dis dis \tieDown dis~
      \arpBarre #3 \stemDown dis4
      \stemUp < c'-3 >16 c c c~
      \arpBarre #3 \stemDown c4 |} \\
    { \arpBarre #3 \stemDown ais,4
      \stemUp < gis'-3 >16 gis gis gis~
      \arpBarre #2 \stemDown gis4
      \stemUp < f'-3 >16 f f f | }
  >>
  \bar "||"

                                %10
  <<
    { \stemUp < fis,,-4-\RH #1 >16 < fis-\RH #3 > < fis-\RH #1 > \tieDown < fis-\RH #3 >~
      \arpBarre #3 \stemDown fis4
      \stemUp  < e'-4 >16 e e e~
      \arpBarre #3 \stemDown e4 | } \\
    { \stemUp s4
      < b-4 >16 b b b~
      \arpBarre #3 \stemDown b4
      \stemUp < a'-4 >16 a a a~ | }
  >>
                                %11
  <<
    { \stemUp < cis-4 >16 cis cis \tieDown cis~
      \arpBarre #3 \stemDown cis4
      \stemUp fis16 fis fis \tieUp fis~
      fis4 | } \\
    { \arpBarre #2 \stemDown a,4
      \stemUp < fis'-4 >16 fis fis fis
      s4
      \stemDown < cis-4 >16 cis cis \tieUp cis~ | }
  >>
                                %12
  <<
    { \stemDown < a-4 >16 a a a~
      \arpBarre #-3 \stemUp a4
      \stemDown < b,-4 >16 b b  \tieUp b~
      \arpBarre #-3 \stemUp b4 | } \\
    { \arpBarre #-2 \stemUp cis'4
      \stemDown < e,-4 >16 e e \tieUp e~
      \arpBarre #-3 \stemUp e4
      \stemDown < fis,-4 >16 fis fis fis | }
  >>
  \bar "|."
}

\score {
  \barreXIpm
}