\version "2.24.0"
%% arp_cm5-7_XIII.ly
%% Beginn: 2025-10-23
%% letzte Änderung: 2025-11-12
arpBarre = #(define-music-function ($grow) (number?)
             #{
             \override Arpeggio.stencil = #ly:arpeggio::brew-chord-bracket 
             \once \override Arpeggio.positions  = #(lambda (grob)
                                                     (let ((iv (ly:arpeggio::calc-positions grob))
                                                           (grow-hi (max 0 (/ $grow 2)))
                                                           (grow-lo (min 0 (/ $grow 2))))
                                                      (cons (+ (car iv) grow-lo) (+ (cdr iv) grow-hi))))
             $(make-music 'EventChord 'elements (list (make-music 'ArpeggioEvent)))
             #})

%% 1. Arpeggio: c Moll 5- 7 c-es-ges-bes XIII. Bund
\score {
  \new Staff {
    \time 4/4
    \key des \major

    \new Voice
    \relative c'' {
      \override Fingering.add-stem-support = ##t
      \override StringNumber.add-stem-support = ##t
      \override StrokeFinger.add-stem-support = ##t
      \set strokeFingerOrientations = #'(up)
      \set fingeringOrientations = #'(left)

      \mark \default
                                %1
      < es-1-\4 >8 < c-3-\5 > < bes-1 > < ges-2-\6 >
      < ges'-4-\4 > es c bes |
                                %2
      < bes'-3-\3 > ges es c
      < c'-1-\2 > bes ges es |
                                %3
      < es'-4-\2 > c bes ges
      < ges'-2-\1 > es c bes |
      \break

      \mark \default
                                %4
      bes c es g
      ges, bes c es |
                                %5
      es, ges bes c
      c, es ges bes |
                                %6
      bes, c es ges
      ges, bes c es |
      \break

      \mark \default
                                %7
      ges' es c bes
      ges es c bes |
                                %8
      ges bes c es
      ges bes c es |
                                %9
      ges1 |
      \bar "|."

      %%                         % Maske
      %% \tuplet 5/4 { < ges-2-\6 >8 < bes-1-\5 > < c-3 > < es-1-\4 > < ges-4 > }
      %% \tuplet 5/4 { < bes-3-\3 > < c-1-\2 > < es-4 > < ges-2 > r } |
    }
  }
}
