\version "2.18.2"
%%**************************************************************************
%% book
%% 20150126
%% angefangen 2015-02-23
%% letzte Bearbeitung 2015-02-23
%%**************************************************************************
%% Noten laden
\include "20150223-score.ly"

%%**************************************************************************
%% Partitur
%%**************************************************************************
%% Druck

#(set-default-paper-size "a4")
#(set-global-staff-size 16)
\book {
  \header {
                                % Mögliche Einträge für Header

                                % Überschriften können für jede \score-Umgebung erstellt werden, sowohl für die gesamte
                                % Datei (oder eine \book-Umgebung) als auch für einzelne Buchabschnitte (innerhalb einer
                                % \bookpart-Umgebung).

                                % Der Inhalt der Titelei wird aus der \header-Umgebung übernommen. Die \header-Umgebung
                                % eines Buches unterstützt folgende Felder:

                                % dedication
                                % Die Widmung der Noten, wird auf oben auf der ersten Seite gesetzt. 

                                % title
                                % Die Überschrift der Noten, wird unter der Widmung zentriert gesetzt. 

                                % subtitle
                                % Untertitel, zentriert unter der Überschrift. 

                                % subsubtitle
                                % Unteruntertitel, zentriert unter dem Untertitel. 

                                % poet
                                % Name des Dichters, linksbündig unter dem Unteruntertitel. 

                                % instrument
                                % Bezeichnung des Instruments, zentriert unter dem Unteruntertitel. Auch oben auf der Seite
                                % zentriert (andere als erste Seite).

                                % composer
                                % Name des Komponisten, rechtsbüngig unter dem Unteruntertitel.

                                % meter
                                % Metrum, linksbündig unter dem Dichter.

                                % arranger
                                % Name des Bearbeiters/Arrangeurs, rechtsbündig unter dem Komponisten.

                                % piece
                                % Bezeichnung des Stückes, linksbündig unter dem Metrum. 

                                % opus
                                % Bezeichnung des Opus, rechtsbündig unter dem Bearbeiter. 

                                % breakbefore
                                % Hiermit beginnt der Titel auf einer neuen Steite. (Kann die Werte ##t (wahr) oder ##f
                                % (falsch) haben.)

                                % copyright
                                % Anzeige eines Copyright, zentriert unten auf der ersten Seite. Um das Copyright-Symbol zu
                                % notieren, siehe Zeichenkodierung.

                                % tagline
                                % Zentriert unten auf der letzten Seite. Enthält standardmäßig: „Music engraving by LilyPond
                                % (version)—www.lilypond.org“

    title = \templatetitel
    subtitle = \templateoriginaltitel
    composer = \templatekomponist
    poet = \templatetexter
    instrument = \templatestimmung
    subsubtitle = \templatekapodaster
    tagline = \templatefusszeile
  }

  \score {
    \template
    \layout {
      indent = 0\cm % Einrückung am Anfang des Stückes
      \context { 
                                % add the RemoveEmptyStaffContext that erases rest-only staves
        \RemoveEmptyStaffContext 
      }
      \context {
        \Score
                                % Remove all-rest staves also in the first system
        \override VerticalAxisGroup #'remove-first = ##t
      }
    }
  }
  %% Ende Druck Partitur
  %%**************************************************************************

  %%**************************************************************************
  %% MIDI Partitur
  \score { % nur midi
    \templatemidi
    \midi {
      \context {
        \Score
        %%erstes MIDI Instrument: Oboe
        midiMaximumVolume = #0.8
        %%zweites MIDI Instrument: Gitarre
        midiMinimumVolume = #0.3
      }
    }
  }
%% Ende MIDI Partitur
%%**************************************************************************

%%**************************************************************************
%% Layout Partitur
  \paper {
    #(set-default-paper-size "a4")
                                %    page-count = 1
    system-system-spacing #'basic-distance = #16
    score-system-spacing =
    #'((basic-distance . 12)
    (minimum-distance . 6)
    (padding . 1)
    (stretchability . 12))
    ragged-last-bottom = ##t
                                %    ragged-bottom = ##t
    oddHeaderMarkup = \markup
    \fill-line {
      \on-the-fly #not-first-page \fromproperty #'header:title
      " " % This will make sure that the header is never completely empty, to
                                % avoid some layout problems. Also, moving it in between the title and
                                % the page number, makes these be typeset left and right aligned, respectively.
      \on-the-fly #print-page-number-check-first \fromproperty #'page:page-number-string
    }

    evenHeaderMarkup = \markup
    \fill-line {
      \on-the-fly #print-page-number-check-first \fromproperty #'page:page-number-string
      " "
      \fromproperty #'header:title
    }
  }
}
%% Ende Layout Partitur
%%**************************************************************************
%% Ende Partitur
%%**************************************************************************
%% Ende book 2015-02-23
%%**************************************************************************
