\version "2.24.0"
%% zwickeln-20101129.ly
%% letzte Bearbeitung 2025-11-22

%% %% ************************************
%% %% Gitarrekram
#(define RH rightHandFinger)
ste = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "1" )))
stb = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "2" )))
stg = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "3" )))
std = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "4" )))
stA = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "5" )))
stE = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "6" )))

ASS = {
  \override Fingering.add-stem-support = ##t
  \override StringNumber.add-stem-support = ##t
  \override StrokeFinger.add-stem-support = ##t
}

fUL = {
  \ASS
  \set strokeFingerOrientations = #'(up)
  \set fingeringOrientations = #'(left)
}

fDL = {
  \ASS
  \set strokeFingerOrientations = #'(down)
  \set fingeringOrientations = #'(left)
}

%% ein- und ausschalten mit \startTextSpan b.z.w. \stopTextSpan
barre = #(define-music-function (str) (string?)
          #{
          \once \override Voice.TextSpanner.edge-text = 
          #(cons (format "C ~a" str) "")
          \once \override Voice.TextSpanner.direction = #1
          \once \override Voice.TextSpanner.edge-height = #'(0 . 0.5)
          \once \override Voice.TextSpanner.padding = #1 
          \once \override Voice.TextSpanner.enclose-bounds = #1
          #})

%% %% Gitarrenkram Ende
%% %% ************************************

% und hier die Noten
gita = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \bar ".|:-|"
  %1
  <<
    { \fUL \stemUp < f-\RH #1 >16^\markup "I." < f-\RH #2 > < f-\RH #1 > \tieDown < f-\RH #2 >~ \stemDown f4 \stemUp  es'16 es es es~ \stemDown es4 | } \\
    { \fUL \stemUp s4\startTextSpan bes16 bes bes bes~ \stemDown bes4 \stemUp as'16 as as as~ | }
  >>
  %2
  <<
    { \stemUp c16 c c \tieDown c~ \stemDown c4 \stemUp f16 f f \tieUp f~ f4 | } \\
    { \stemDown as,4 \stemUp f'16 f f f s4 \stemDown c16 c c c~ | }
  >>
  %3
  <<
    { \stemDown as16 as as as~ \stemUp as4 \stemDown bes,16 bes bes  \tieUp bes~ \stemUp bes4 |} \\
    { \stemUp c'4 \stemDown es,16 es es \tieUp es~ \stemUp es4 \stemDown f,16 f f f\stopTextSpan | }
  >>

  %4
  <<
    { \stemUp < e-\RH #1 >16 < e-\RH #2 > < e-\RH #1 > \tieDown < e-\RH #2 >~ \stemDown e4 \stemUp  d'16 d d d~ \stemDown d4 | } \\
    { \stemUp s4 a16 a a a~ \stemDown a4 \stemUp g'16 g g g~ | }
  >>
  %5
  <<
    { \stemUp b16 b b \tieDown b~ \stemDown b4 \stemUp e16 e e \tieUp e~ e4 | } \\
    { \stemDown g,4 \stemUp e'16 e e e s4 \stemDown b16 b b \tieUp b~ | }
  >>
  %6
  <<
    { \stemDown g16 g g g~ \stemUp g4 \stemDown a,16 a a a~ \stemUp a4 |} \\
    { \stemUp b'4 \stemDown d,16 d d \tieUp d~ \stemUp d4 \stemDown e,16 e e e | }
  >>
  |
  \bar ":..:"
}

gitb = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \bar ":..:"
  %7
  <<
    { \fUL \stemUp \tuplet 3/2 { < fis-\RH #1 >8^\markup "II." < fis-\RH #2 > \tieDown < fis-\RH #1 >~ } \stemDown fis4 \stemUp \tuplet 3/2 { e'8 e e~ } \stemDown e4 | } \\
    { \fUL \stemUp s4\startTextSpan \tuplet 3/2 { < b-\RH #2 >8 < b-\RH #1 > < b-\RH #2 >~ } \stemDown b4 \stemUp \tuplet 3/2 { a'8 a a~ } | }
  >>
  %8
  <<
    { \stemUp \tuplet 3/2 { cis8 cis \tieDown cis~ } \stemDown cis4 \stemUp \tuplet 3/2 { fis8 fis \tieUp fis~ } fis4 | } \\
    { \stemDown a,4 \stemUp \tuplet 3/2 { fis'8 fis fis } s4 \stemDown \tuplet 3/2 { cis8 cis cis~ } | }
  >>
  %9
  <<
    { \stemDown \tuplet 3/2 { a8 a a~ } \stemUp a4 \stemDown \tuplet 3/2 { b,8 b \tieUp b~ } \stemUp b4 | } \\
    { \stemUp cis'4 \stemDown \tuplet 3/2 { e,8 e \tieUp e~ } \stemUp e4 \stemDown \tuplet 3/2 { fis,8 fis fis\stopTextSpan } | }
  >>

  %10
  <<
    { \stemUp \tuplet 3/2 { e8^\markup "II." e \tieDown e~ } \stemDown e4 \stemUp \tuplet 3/2 { d'8 d d~ } \stemDown d4 | } \\
    { \stemUp s4\startTextSpan \tuplet 3/2 { a8 a a~ } \stemDown a4 \stemUp \tuplet 3/2 { g'8 g g~ } | }
  >>
  %11
  <<
    { \stemUp \tuplet 3/2 { b8 b \tieDown b~ } \stemDown b4 \stemUp \tuplet 3/2 { e8 e \tieUp e~ } e4 | } \\
    { \stemDown g,4 \stemUp \tuplet 3/2 { e'8 e e } s4 \stemDown \tuplet 3/2 { b8 b b~ } | }
  >>
  %12
  <<
    { \stemDown \tuplet 3/2 { g8 g g~ } \stemUp g4 \stemDown \tuplet 3/2 { a,8 a \tieUp a~ } \stemUp a4 | } \\
    { \stemUp b'4 \stemDown \tuplet 3/2 { d,8 d \tieUp d~ } \stemUp d4 \stemDown \tuplet 3/2 { e,8 e e\stopTextSpan } | }
  >>
  |
  \bar ":..:"
}

gitc = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \bar ":..:"
  %13
  <<
    { \fUL \stemUp < g-\RH #1 >8^\markup "III." < g-\RH #2 >~ \stemDown g4 \stemUp f'8 f~ \stemDown f4 | } \\
    { \fUL \stemUp s4\startTextSpan c8 c~ \stemDown c4 \stemUp bes'8 bes~ | }
  >>
  %14
  <<
    { \stemUp d8 \tieDown d~ \stemDown d4 \stemUp g8 \tieUp g~ g4 | } \\
    { \stemDown bes,4 \stemUp g'8 g s4 \stemDown d8 d~ | }
  >>
  %15
  <<
    { \stemDown bes8 bes~ \stemUp bes4 \stemDown c,8 \tieUp c~ \stemUp c4 |} \\
    { \stemUp d'4 \stemDown f,8 \tieUp f~ \stemUp f4 \stemDown g,8 g\stopTextSpan | }
  >>

  %16
  <<
    { \stemUp e8 \tieDown e~ \stemDown e4 \stemUp  d'8 d~ \stemDown d4 | } \\
    { \stemUp s4 a8 a~ \stemDown a4 \stemUp g'8 g~ | }
  >>
  %17
  <<
    { \stemUp b8 \tieDown b~ \stemDown b4 \stemUp e8 \tieUp e~ e4 | } \\
    { \stemDown g,4 \stemUp e'8 e s4 \stemDown b8 \tieUp b~ | }
  >>
  %18
  <<
    { \stemDown g8 g~ \stemUp g4 \stemDown a,8 a~ \stemUp a4 |} \\
    { \stemUp b'4 \stemDown d,8 \tieUp d~ \stemUp d4 \stemDown e,8 e | }
  >>
  |
  \bar ":..:"
}

gitd = \relative c {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  
  \bar ":..:"
  %19
  <<
    { \fUL \tieDown\stemUp < gis-\RH #1 >8~^\markup "IV."\noBeam\stemDown gis\noBeam \stemUp < fis'-\RH #1 >~\noBeam \stemDown fis\noBeam } \\
    { \fUL \stemUp s8\noBeam\startTextSpan < cis-\RH #2 >~\noBeam \stemDown cis\noBeam \stemUp < b'-\RH #2 >~\noBeam }
  >>
  %20
  <<
    { \stemUp\tieDown < dis-\RH #1 >~\noBeam \stemDown dis\noBeam \stemUp\tieUp < gis-\RH #1 >~\noBeam gis\noBeam | } \\
    { \stemDown b,\noBeam \stemUp < gis'-\RH #2 > s\noBeam \stemDown < dis-\RH #2 >~\noBeam | }
  >>
  %21
  <<
    { \stemDown < b-\RH #1 >~\noBeam \stemUp b\noBeam \stemDown \tieUp < cis,-\RH #1 >~\noBeam \stemUp cis\noBeam } \\
    { \stemUp dis'\noBeam\stemDown \tieUp < fis,-\RH #2 >~\noBeam\stemUp fis\noBeam\stemDown < gis,-\RH #2 >\noBeam\stopTextSpan }
  >>

  %22
  <<
    { \tieDown\stemUp e~\noBeam \stemDown e\noBeam \stemUp d'~\noBeam \stemDown d\noBeam | } \\
    { \stemUp s a~\noBeam \stemDown a\noBeam \stemUp g'~\noBeam | }
  >>
  %23
  <<
    { \stemUp\tieDown b~\noBeam \stemDown b\noBeam \stemUp\tieUp e~\noBeam e\noBeam } \\
    { \stemDown g,\noBeam \stemUp e'\noBeam s \stemDown b~\noBeam }
  >>
  %24
  <<
    { \stemDown g~\noBeam \stemUp g\noBeam \stemDown \tieUp a,~\noBeam \stemUp a\noBeam |} \\
    { \stemUp b'\noBeam \stemDown \tieUp d,~\noBeam \stemUp d\noBeam \stemDown e,\noBeam | }
  >>
  |
  \bar ":..:"
}

% \book {
%   \score {
%     {
%       \gita
%       \break
%       \gitb
%       \break
%       \gitc
%       \break
%       \gitd
%     }
%   }
% }

\book {
  \score {
    \gita
  }
}

\book {
  \score {
    \gitb
  }
}

\book {
  \score {
    \gitc
  }
}

\book {
  \score {
    \gitd
  }
}
