\version "2.24.0"
%% wechselanschlag-20101129.ly
%% letzte Bearbeitung 2025-12-02

%% %% ************************************
%% %% Gitarrekram
#(define RH rightHandFinger)
ste = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "1" )))
stb = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "2" )))
stg = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "3" )))
std = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "4" )))
stA = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "5" )))
stE = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "6" )))

ASS = {
  \override Fingering.add-stem-support = ##t
  \override StringNumber.add-stem-support = ##t
  \override StrokeFinger.add-stem-support = ##t
}

fUL = {
  \ASS
  \set strokeFingerOrientations = #'(up)
  \set fingeringOrientations = #'(left)
}

fDL = {
  \ASS
  \set strokeFingerOrientations = #'(down)
  \set fingeringOrientations = #'(left)
}

%% %% Gitarrenkram Ende
%% %% ************************************

% und hier die Noten
gita = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \bar ".|:-|"
  %1
  < f-1\6-\RH #4 >16 < ges-2-\RH #3 >8. < as-4 >4 \breathe
  < bes\5 >16 b8. des4 \breathe
  < es\4 >16 e8. fis4 \breathe
  < gis\3 >16 a8. b4 \breathe
  |

  %2
  < c\2 >16 des8. es4 \breathe
  < f\1 >16 ges8. as4 \breathe
  f16 ges8. as4 \breathe
  c,16 des8. es4 \breathe
  |

  %3
  gis,16 a8. b4 \breathe
  es,16 e8. fis4 \breathe
  bes,16 b8. des4 \breathe
  f,16 ges8. as4 \breathe
  |
  \bar ":..:"
}

gitb = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \bar ":..:"
  %1
  < f-1\6-\RH #4 >4 < ges-2-\RH #3 >16 < as-4 >8. \breathe
  < bes\5 >4 b16 des8. \breathe
  < es\4 >4 e16 fis8. \breathe
  < gis\3 >4 a16 b8. \breathe
  |

  %2
  < c\2 >4 des16 es8. \breathe
  < f\1 >4 ges16 as8. \breathe
  f4 ges16 as8. \breathe
  c,4 des16 es8. \breathe
  |

  %3
  gis,4 a16 b8. \breathe
  es,4 e16 fis8. \breathe
  bes,4 b16 des8. \breathe
  f,4 ges16 as8. \breathe
  |
  \bar ":..:"
}

gitcOne = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \bar ":..:"
  %1
  < f-1\6-\RH #4 >16\accent < ges-2-\RH #3 >16 < as-4 >8 \breathe
  < bes\5 >16\accent b16 des8 \breathe
  < es\4 >16\accent e16 fis8 \breathe
  < gis\3 >16\accent a16 b8 \breathe
  |
  %2
  < c\2 >16\accent des16 es8 \breathe
  < f\1 >16\accent ges16 as8 \breathe
  f16\accent ges16 as8 \breathe
  c,16\accent des16 es8 \breathe
  |
  %3
  gis,16\accent a16 b8 \breathe
  es,16\accent e16 fis8 \breathe
  bes,16\accent b16 des8 \breathe
  f,16\accent ges16 as8 \breathe
  |
  \bar "||"

  %4
  f16 ges16\accent as8 \breathe
  bes16 b16\accent des8 \breathe
  es16 e16\accent fis8 \breathe
  gis16 a16\accent b8 \breathe
  |
}

gitcFive = \relative c' {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #5
  %5
  c16 des16\accent es8 \breathe
  f16 ges16\accent as8 \breathe
  f16 ges16\accent as8 \breathe
  c,16 des16\accent es8 \breathe
  |
  %6
  gis,16 a16\accent b8 \breathe
  es,16 e16\accent fis8 \breathe
  bes,16 b16\accent des8 \breathe
  f,16 ges16\accent as8 \breathe
  |
  \bar "||"

  %7
  f16 ges16 as8\accent \breathe
  bes16 b16 des8\accent \breathe
  es16 e16 fis8\accent \breathe
  gis16 a16 b8\accent \breathe
  |
  %8
  c16 des16 es8\accent \breathe
  f16 ges16 as8\accent \breathe
  f16 ges16 as8\accent \breathe
  c,16 des16 es8\accent \breathe
  |
  %9
  gis,16 a16 b8\accent \breathe
  es,16 e16 fis8\accent \breathe
  bes,16 b16 des8\accent \breathe
  f,16 ges16 as8\accent \breathe
  |
  \bar ":..:"
}

gitdOne = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \bar ":..:"
  %1
  \tuplet 3/2 { < f-1\6-\RH #4 >8\accent < ges-2-\RH #3 > < as-4 > \breathe }
  \tuplet 3/2 { < bes\5 >8\accent b des \breathe }
  \tuplet 3/2 { < es\4 >8\accent e fis \breathe }
  \tuplet 3/2 { < gis\3 >8\accent a b \breathe }
  |
  %2
  \tuplet 3/2 { < c\2 >8\accent des es \breathe }
  \tuplet 3/2 { < f\1 >8\accent ges as \breathe }
  \tuplet 3/2 { f8\accent ges as \breathe }
  \tuplet 3/2 { c,8\accent des es \breathe }
  |
  %3
  \tuplet 3/2 { gis,8\accent a b \breathe }
  \tuplet 3/2 { es,8\accent e fis \breathe }
  \tuplet 3/2 { bes,8\accent b des \breathe }
  \tuplet 3/2 { f,8\accent ges as \breathe }
  |
  \bar "||"
  %4
  \tuplet 3/2 { f8 ges\accent as \breathe }
  \tuplet 3/2 { bes8 b\accent des \breathe }
  \tuplet 3/2 { es8 e\accent fis \breathe }
  \tuplet 3/2 { gis8 a\accent b \breathe }
  |
}

gitdFive = \relative c' {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #5
  %5
  \tuplet 3/2 { c8 des\accent es \breathe }
  \tuplet 3/2 { f8 ges\accent as \breathe }
  \tuplet 3/2 { f8 ges\accent as \breathe }
  \tuplet 3/2 { c,8 des\accent es \breathe }
  |
  %6
  \tuplet 3/2 { gis,8 a\accent b \breathe }
  \tuplet 3/2 { es,8 e\accent fis \breathe }
  \tuplet 3/2 { bes,8 b\accent des \breathe }
  \tuplet 3/2 { f,8 ges\accent as \breathe }
  |
  \bar "||"

  %7
  \tuplet 3/2 { f8 ges as\accent \breathe }
  \tuplet 3/2 { bes8 b des\accent \breathe }
  \tuplet 3/2 { es8 e fis\accent \breathe }
  \tuplet 3/2 { gis8 a b\accent \breathe }
  |
  %8
  \tuplet 3/2 { c8 des es\accent \breathe }
  \tuplet 3/2 { f8 ges as\accent \breathe }
  \tuplet 3/2 { f8 ges as\accent \breathe }
  \tuplet 3/2 { c,8 des es\accent \breathe }
  |
  %9
  \tuplet 3/2 { gis,8 a b\accent \breathe }
  \tuplet 3/2 { es,8 e fis\accent \breathe }
  \tuplet 3/2 { bes,8 b des\accent \breathe }
  \tuplet 3/2 { f,8 ges as\accent }
  |
  \bar ":..:"
}

gite = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \bar ":..:"
  %1
  < f-1\6-\RH #4 >16 < ges-2-\RH #3 >8. \breathe
  < as-4 >16 < bes\5 >8.  \breathe
  b16 des8. \breathe
  < es\4 >16 e8.  \breathe
  |
  %2
  fis16 < gis\3 >8.  \breathe
  a16 b8.
  < c\2 >16 des8. \breathe
  es16 < f\1 >8. \breathe
  |
  %3
  ges16 as8. \breathe
  f16 ges8. \breathe
  as16 c,8. \breathe
  des16 es8. \breathe
  |
  %4
  gis,16 a8. \breathe
  b16 es,8. \breathe
  e16 fis8. \breathe
  bes,16 b8. \breathe
  |

  %5
  \time 2/4
  des16 f,8. \breathe
  ges16 as8.
  \time 4/4
  |
  \bar ":..:"
}

gitfOne = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \bar ":..:"
  %1
  \tuplet 3/2 { < f-1\6-\RH #4 >8\accent < ges-2-\RH #3 > < as-4 > }
  \tuplet 3/2 { < bes\5 >8\accent b des \breathe }
  \tuplet 3/2 { < es\4 >8\accent e fis }
  \tuplet 3/2 { < gis\3 >8\accent a b \breathe }
  |
  %2
  \tuplet 3/2 { < c\2 >8\accent des es }
  \tuplet 3/2 { < f\1 >8\accent ges as \breathe }
  \tuplet 3/2 { f8\accent ges as \breathe }
  \tuplet 3/2 { c,8\accent des es }
  |
  %3
  \tuplet 3/2 { gis,8\accent a b }
  \tuplet 3/2 { es,8\accent e fis \breathe }
  \tuplet 3/2 { bes,8\accent b des }
  \tuplet 3/2 { f,8\accent ges as \breathe }
  |
  \bar "||"

  %4
  \tuplet 3/2 { f8 ges\accent as }
  \tuplet 3/2 { bes8 b\accent des \breathe }
  \tuplet 3/2 { es8 e\accent fis }
  \tuplet 3/2 { gis8 a\accent b \breathe }
  |
}

gitfFive = \relative c' {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #5
  %5
  \tuplet 3/2 { c8 des\accent es }
  \tuplet 3/2 { f8 ges\accent as \breathe }
  \tuplet 3/2 { f8 ges\accent as }
  \tuplet 3/2 { c,8 des\accent es \breathe }
  |
  %6
  \tuplet 3/2 { gis,8 a\accent b }
  \tuplet 3/2 { es,8 e\accent fis \breathe }
  \tuplet 3/2 { bes,8 b\accent des }
  \tuplet 3/2 { f,8 ges\accent as \breathe }
  |
  \bar "||"

  %7
  \tuplet 3/2 { f8 ges as\accent }
  \tuplet 3/2 { bes8 b des\accent \breathe }
  \tuplet 3/2 { es8 e fis\accent }
  \tuplet 3/2 { gis8 a b\accent \breathe }
  |
  %8
  \tuplet 3/2 { c8 des es\accent }
  \tuplet 3/2 { f8 ges as\accent \breathe }
  \tuplet 3/2 { f8 ges as\accent }
  \tuplet 3/2 { c,8 des es\accent \breathe }
  |
  %9
  \tuplet 3/2 { gis,8 a b\accent }
  \tuplet 3/2 { es,8 e fis\accent \breathe }
  \tuplet 3/2 { bes,8 b des\accent \breathe }
  \tuplet 3/2 { f,8 ges as\accent \breathe }
  |
  \bar ":..:"
}

gitgOne = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \bar ":..:"
  %1
  \tuplet 3/2 { < f-1\6-\RH #4 >8\accent < ges-2-\RH #3 > < as-4 > }
  \tuplet 3/2 { < bes\5 >8\accent b des }
  \tuplet 3/2 { < es\4 >8\accent e fis \breathe }
  \tuplet 3/2 { < gis\3 >8\accent a b }
  |
  %2
  \tuplet 3/2 { < c\2 >8\accent des es }
  \tuplet 3/2 { < f\1 >8\accent ges as \breathe }
  \tuplet 3/2 { f8\accent ges as }
  \tuplet 3/2 { c,8\accent des es }
  |
  %3
  \tuplet 3/2 { gis,8\accent a b \breathe }
  \tuplet 3/2 { es,8\accent e fis }
  \tuplet 3/2 { bes,8\accent b des }
  \tuplet 3/2 { f,8\accent ges as \breathe }
  |
  \bar "||"

  %4
  \tuplet 3/2 { f8 ges\accent as }
  \tuplet 3/2 { bes8 b\accent des }
  \tuplet 3/2 { es8 e\accent fis \breathe }
  \tuplet 3/2 { gis8 a\accent b }
  |
}

gitgFive = \relative c' {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #5
  %5
  \tuplet 3/2 { c8 des\accent es }
  \tuplet 3/2 { f8 ges\accent as \breathe }
  \tuplet 3/2 { f8 ges\accent as }
  \tuplet 3/2 { c,8 des\accent es }
  |
  %6
  \tuplet 3/2 { gis,8 a\accent b \breathe }
  \tuplet 3/2 { es,8 e\accent fis }
  \tuplet 3/2 { bes,8 b\accent des }
  \tuplet 3/2 { f,8 ges\accent as \breathe }
  |
  \bar "||"

  %7
  \tuplet 3/2 { f8 ges as\accent }
  \tuplet 3/2 { bes8 b des\accent }
  \tuplet 3/2 { es8 e fis\accent \breathe }
  \tuplet 3/2 { gis8 a b\accent }
  |
  %8
  \tuplet 3/2 { c8 des es\accent }
  \tuplet 3/2 { f8 ges as\accent \breathe }
  \tuplet 3/2 { f8 ges as\accent }
  \tuplet 3/2 { c,8 des es\accent }
  |
  %9
  \tuplet 3/2 { gis,8 a b\accent \breathe }
  \tuplet 3/2 { es,8 e fis\accent }
  \tuplet 3/2 { bes,8 b des\accent }
  \tuplet 3/2 { f,8 ges as\accent }
  |
  \bar ":..:"
}

githOne = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \bar ":..:"
  %1
  \tuplet 3/2 { < f-1\6-\RH #4 >8\accent < ges-2-\RH #3 > < as-4 > }
  \tuplet 3/2 { < bes\5 >8\accent b des }
  \tuplet 3/2 { < es\4 >8\accent e fis }
  \tuplet 3/2 { < gis\3 >8\accent a b }
  |
  %2
  \tuplet 3/2 { < c\2 >8\accent des es }
  \tuplet 3/2 { < f\1 >8\accent ges as \breathe }
  \tuplet 3/2 { f8\accent ges as }
  \tuplet 3/2 { c,8\accent des es }
  |
  %3
  \tuplet 3/2 { gis,8\accent a b }
  \tuplet 3/2 { es,8\accent e fis }
  \tuplet 3/2 { bes,8\accent b des }
  \tuplet 3/2 { f,8\accent ges as \breathe }
  |
  \bar "||"

  %4
  \tuplet 3/2 { f8 ges\accent as }
  \tuplet 3/2 { bes8 b\accent des }
  \tuplet 3/2 { es8 e\accent fis }
  \tuplet 3/2 { gis8 a\accent b }
  |
}

githFive = \relative c' {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \fDL
  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #5
  %5
  \tuplet 3/2 { c8 des\accent es }
  \tuplet 3/2 { f8 ges\accent as \breathe }
  \tuplet 3/2 { f8 ges\accent as }
  \tuplet 3/2 { c,8 des\accent es }
  |
  %6
  \tuplet 3/2 { gis,8 a\accent b }
  \tuplet 3/2 { es,8 e\accent fis }
  \tuplet 3/2 { bes,8 b\accent des }
  \tuplet 3/2 { f,8 ges\accent as \breathe }
  |
  \bar "||"

  %7
  \tuplet 3/2 { f8 ges as\accent }
  \tuplet 3/2 { bes8 b des\accent }
  \tuplet 3/2 { es8 e fis\accent }
  \tuplet 3/2 { gis8 a b\accent }
  |
  %8
  \tuplet 3/2 { c8 des es\accent }
  \tuplet 3/2 { f8 ges as\accent \breathe }
  \tuplet 3/2 { f8 ges as\accent }
  \tuplet 3/2 { c,8 des es\accent }
  |
  %9
  \tuplet 3/2 { gis,8 a b\accent }
  \tuplet 3/2 { es,8 e fis\accent }
  \tuplet 3/2 { bes,8 b des\accent }
  \tuplet 3/2 { f,8 ges as\accent }
  |
  \bar ":|."

%  \set Staff.instrumentName = "git"
%  \set Staff.midiInstrument = #"acoustic guitar (steel)"
}


% \book {
%   \score {
%     {
%       \gita
%       \break
%       \gitb
%       \break
%       \gitc
%       \break
%       \gitd
%       \break
%       \gite
%       \break
%       \gitf
%       \break
%       \gitg
%       \break
%       \gith
%     }
%   }
% }

#(define output-suffix "1")
\book {
  \score {
    \gita
  }
}

#(define output-suffix "2")
\book {
  \score {
    \gitb
  }
}

#(define output-suffix "3a")
\book {
  \score {
    \gitcOne
  }
}

#(define output-suffix "3b")
\book {
  \paper { indent = 0.0 }

  \score {
    \gitcFive
  }
}

#(define output-suffix "4a")
\book {
  \score {
    \gitdOne
  }
}

#(define output-suffix "4b")
\book {
  \paper { indent = 0.0 }

  \score {
    \gitdFive
  }
}

#(define output-suffix "5")
\book {
  \score {
    \gite
  }
}

#(define output-suffix "6a")
\book {
  \score {
    \gitfOne
  }
}

#(define output-suffix "6b")
\book {
  \paper { indent = 0.0 }

  \score {
    \gitfFive
  }
}

#(define output-suffix "7a")
\book {
  \score {
    \gitgOne
  }
}

#(define output-suffix "7b")
\book {
  \paper { indent = 0.0 }

  \score {
    \gitgFive
  }
}

#(define output-suffix "8a")
\book {
  \score {
    \githOne
  }
}

#(define output-suffix "8b")
\book {
  \paper { indent = 0.0 }

  \score {
    \githFive
  }
}