\version "2.24.0"
%% tremolo-20101130.ly
%% letzte Bearbeitung 2025-12-03

%% %% ************************************
%% %% Gitarrekram
#(define RH rightHandFinger)
ste = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "1" )))
stb = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "2" )))
stg = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "3" )))
std = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "4" )))
stA = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "5" )))
stE = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "6" )))

ASS = {
  \override Fingering.add-stem-support = ##t
  \override StringNumber.add-stem-support = ##t
  \override StrokeFinger.add-stem-support = ##t
}

fUL = {
  \ASS
  \set strokeFingerOrientations = #'(up)
  \set fingeringOrientations = #'(left)
}

fDL = {
  \ASS
  \set strokeFingerOrientations = #'(down)
  \set fingeringOrientations = #'(left)
}

%% %% Gitarrenkram Ende
%% %% ************************************

%% %% ************************************
%% und hier die Noten
gitaA = \relative c' {
  \key c \major
  \time 9/8
  \clef "treble_8"

  \bar ".|:-|"
                                %1
  <<
    { \override StrokeFinger.avoid-slur = #'inside \fUL < e-\RH #4 >32[( < e-\RH #3 > < e-\RH #2 > < e-\RH #3 > ] < e-\RH #4 >8) e32[( e e e ] e[ e e e ] e8) e32[( e e e ] e[ e e e ] e[ e e e ] e8) } \\
    { \override StrokeFinger.avoid-slur = #'inside \fUL < b-\RH #1 >8[ b ] b[ b b ] b[ b b b ] }
  >> |
                                %2
  <<
    { b32[( b b b ] b8) b32[( b b b ] b[ b b b ] b8) b32[( b b b ] b[ b b b ] b[ b b b ] b8) } \\
    { g8[ g ] g[ g g ] g[ g g g ] }
  >> |
}

gitaB = \relative c' {
  \key c \major
  \time 9/8
  \clef "treble_8"

  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #3
                                %3
  <<
    { \override StrokeFinger.avoid-slur = #'inside \fUL g32[( g g g ] g8) g32[( g g g ] g[ g g g ] g8) g32[( g g g ] g[ g g g ] g[ g g g ] g8) } \\
    { \override StrokeFinger.avoid-slur = #'inside \fUL d8[ d ] d[ d d ] d[ d d d ] }
  >> |
                                %4
  <<
    { b'32[( b b b ] b8) b32[( b b b ] b[ b b b ] b8) b32[( b b b ] b[ b b b ] b[ b b b ] b8) } \\
    { g8[ g ] g[ g g ] g[ g g g ] }
  >> |
  |
  \bar ":..:"
}

gitbA = \relative c' {
  \key c \major
  \time 9/8
  \clef "treble_8"

  \bar ":..:"

                                %1
  <<
    { \override StrokeFinger.avoid-slur = #'inside \fUL < e-\RH #4 >32[( < e-\RH #3 > < e-\RH #2 > < e-\RH #3 > ] < e-\RH #4 >8) e32[( e e e ] e[ e e e ] e8) e32[( e e e ] e[ e e e ] e[ e e e ] e8) } \\
    { \override StrokeFinger.avoid-slur = #'inside \fUL < g,-\RH #1 >8[ g ] g[ g g ] g[ g g g ] }
  >> |
                                %2
  <<
    { b32[( b b b ] b8) b32[( b b b ] b[ b b b ] b8) b32[( b b b ] b[ b b b ] b[ b b b ] b8) } \\
    { d,8[ d ] d[ d d ] d[ d d d ] }
  >> |
}

gitbB = \relative c' {
  \key c \major
  \time 9/8
  \clef "treble_8"

  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #3
                                %3
  <<
    { \override StrokeFinger.avoid-slur = #'inside \fUL g32[( g g g ] g8) g32[( g g g ] g[ g g g ] g8) g32[( g g g ] g[ g g g ] g[ g g g ] g8) } \\
    { \override StrokeFinger.avoid-slur = #'inside \fUL a,8[ a ] a[ a a ] a[ a a a ] }
  >> |
                                %4
  <<
    { b'32[( b b b ] b8) b32[( b b b ] b[ b b b ] b8) b32[( b b b ] b[ b b b ] b[ b b b ] b8) } \\
    { d,8[ d ] d[ d d ] d[ d d d ] }
  >> |
  |
  \bar ":..:"
}

gitcA = \relative c' {
  \key c \major
  \time 9/8
  \clef "treble_8"

  \bar ":..:"
                                %1
  <<
    { \override StrokeFinger.avoid-slur = #'inside \fUL < e-\RH #4 >32[( < e-\RH #3 > < e-\RH #2 > < e-\RH #3 > ] < e-\RH #4 >8) e32[( e e e ] e[ e e e ] e8) e32[( e e e ] e[ e e e ] e[ e e e ] e8) } \\
    { \override StrokeFinger.avoid-slur = #'inside \fUL < d,-\RH #1 >8[ d ] d[ d d ] d[ d d d ] }
  >> |
                                %2
  <<
    { \override StrokeFinger.avoid-slur = #'inside \fUL b'32[( b b b ] b8) b32[( b b b ] b[ b b b ] b8) b32[( b b b ] b[ b b b ] b[ b b b ] b8) } \\
    { \override StrokeFinger.avoid-slur = #'inside \fUL a,8[ a ] a[ a a ] a[ a a a ] }
  >> |
}

gitcB = \relative c' {
  \key c \major
  \time 9/8
  \clef "treble_8"

  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #3
                                %3
  <<
    { g'32[( g g g ] g8) g32[( g g g ] g[ g g g ] g8) g32[( g g g ] g[ g g g ] g[ g g g ] g8) } \\
    { e,8[ e ] e[ e e ] e[ e e e ] }
  >> |
                                %4
  <<
    { b''32[( b b b ] b8) b32[( b b b ] b[ b b b ] b8) b32[( b b b ] b[ b b b ] b[ b b b ] b8) } \\
    { a,8[ a ] a[ a a ] a[ a a a ] }
  >> |
  |
  \bar ":..:"
}

gitd = \relative c' {
  \key c \major
  \time 9/8
  \clef "treble_8"

  \fDL
  \bar ":..:"
                                %13
  <<
    { \override StrokeFinger.avoid-slur = #'inside \fUL < e-\RH #4 >32[( < e-\RH #3 > < e-\RH #2 > < e-\RH #3 > ] < e-\RH #4 >8) e32[( e e e ] e[ e e e ] e8) e32[( e e e ] e[ e e e ] e[ e e e ] e8) } \\
    { \override StrokeFinger.avoid-slur = #'inside \fUL < a,,-\RH #1 >8[ a ] a[ a a ] a[ a a a ] }
  >> |
                                %14
  <<
    { b'32[( b b b ] b8) b32[( b b b ] b[ b b b ] b8) b32[( b b b ] b[ b b b ] b[ b b b ] b8) } \\
    { e,,8[ e ] e[ e e ] e[ e e e ] }
  >> |
  |
  \bar ":..:"
}

gite = \relative c' {
  \key c \major
  \time 9/8
  \clef "treble_8"

  \fDL
  \bar ":..:"
                                %15
  <<
    { \override StrokeFinger.avoid-slur = #'inside \fUL < e-\RH #4 >32[( < e-\RH #3 > < e-\RH #2 > < e-\RH #3 > ] < e-\RH #4 >8) e32[( e e e ] e[ e e e ] e8) e32[( e e e ] e[ e e e ] e[ e e e ] e8) } \\
    { \override StrokeFinger.avoid-slur = #'inside \fUL < e,,-\RH #1 >8[ e ] e[ e e ] e[ e e e ] }
  >> |
  |
  \bar ":..:"
}


                                % \book {
                                %   \score {
                                %     {
                                %       \gita
                                %       \break
                                %       \gitb
                                %       \break
                                %       \gitc
                                %       \break
                                %       \gitd
                                %       \break
                                %       \gite
                                %     }
                                %   }
                                % }

#(define output-suffix "1a")
\book {
  \score {
    \gitaA
  }
}

#(define output-suffix "1b")
\book {
  \paper { indent = 0.0 }
  \score {
    \gitaB
  }
}

#(define output-suffix "2a")
\book {
  \score {
    \gitbA
  }
}

#(define output-suffix "2b")
\book {
  \paper { indent = 0.0 }
  \score {
    \gitbB
  }
}

#(define output-suffix "3a")
\book {
  \score {
    \gitcA
  }
}

#(define output-suffix "3b")
\book {
  \paper { indent = 0.0 }
  \score {
    \gitcB
  }
}

#(define output-suffix "4")
\book {
  \score {
    \gitd
  }
}

#(define output-suffix "5")
\book {
  \score {
    \gite
  }
}

