\version "2.24.0"
%% legato-20101129.ly
%% letzte Bearbeitung 2025-12-02

%% %% ************************************
%% %% Gitarrekram
#(define RH rightHandFinger)
ste = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "1" )))
stb = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "2" )))
stg = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "3" )))
std = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "4" )))
stA = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "5" )))
stE = #(make-dynamic-script (markup 
                             #:line( #:text #:circle #:finger "6" )))

ASS = {
  \override Fingering.add-stem-support = ##t
  \override StringNumber.add-stem-support = ##t
  \override StrokeFinger.add-stem-support = ##t
}

fUL = {
  \ASS
  \set strokeFingerOrientations = #'(up)
  \set fingeringOrientations = #'(left)
}

fDL = {
  \ASS
  \set strokeFingerOrientations = #'(down)
  \set fingeringOrientations = #'(left)
}

%% %% Gitarrenkram Ende
%% %% ************************************


% und hier die Noten
gita = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL

  \repeat volta 2 {
                                %1
    < f-1\6-\RH #1 >16( < g-3 >8.)( < as-4 >4) \breathe
    < bes\5 >16( c8.)( des4) \breathe |
                                %2
    < es\4 >16( f8.)( fis4) \breathe
    < gis\3 >16( ais8.)( b4) \breathe |

                                %3
    < c\2 >16( d8.)( es4) \breathe
    < f\1 >16( g8.)( as4) \breathe |
                                %4
    f16( g8.)( as4) \breathe
    c,16( d8.)( es4) \breathe |

                                %5
    gis,16( ais8.)( b4) \breathe
    es,16( f8.)( fis4) \breathe |
                                %6
    bes,16( c8.)( des4) \breathe
    f,16( g8.)( as4) \breathe |
  }
}

gitb = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %1
  < f-1\6-\RH #1 >4( < g-3 >16)( < as-4 >8.) \breathe
  < bes\5 >4( c16)( des8.) \breathe
  < es\4 >4( f16)( fis8.) \breathe
  < gis\3 >4( ais16)( b8.) \breathe
  |

  %2
  < c\2 >4( d16)( es8.) \breathe
  < f\1 >4( g16)( as8.) \breathe
  < f >4( g16)( as8.) \breathe
  < c, >4( d16)( es8.) \breathe
  |

  %3
  gis,4( ais16)( b8.) \breathe
  es,4( f16)( fis8.) \breathe
  bes,4( c16)( des8.) \breathe
  f,4( g16)( as8.) \breathe
  |
  \bar ":..:"
}

gitcOne = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %1
  < f-1\6-\RH #1 >16(\accent < g-3 >16)( < as-4 >8) \breathe
  < bes\5 >16(\accent c16)( des8) \breathe
  < es\4 >16(\accent f16)( fis8) \breathe
  < gis\3 >16(\accent ais16)( b8) \breathe
  |
  %2
  < c\2 >16(\accent d16)( es8) \breathe
  < f\1 >16(\accent g16)( as8) \breathe
  < f >16(\accent g16)( as8) \breathe
  < c, >16(\accent d16)( es8) \breathe
  |
  %3
  gis,16(\accent ais16)( b8) \breathe
  es,16(\accent f16)( fis8) \breathe
  bes,16(\accent c16)( des8) \breathe
  f,16(\accent g16)( as8) \breathe
  |
  \bar "||"

  %4
  f16( g16)(\accent as8) \breathe
  bes16( c16)(\accent des8) \breathe
  es16( f16)(\accent fis8) \breathe
  gis16( ais16)(\accent b8) \breathe
  |
}

gitcFive = \relative c' {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #5
                                %5
  c16( d16)(\accent es8) \breathe
  f16( g16)(\accent as8) \breathe
  f16( g16)(\accent as8) \breathe
  c,16( d16)(\accent es8) \breathe
  |
  %6
  gis,16( ais16)(\accent b8) \breathe
  es,16( f16)(\accent fis8) \breathe
  bes,16( c16)(\accent des8) \breathe
  f,16( g16)(\accent as8) \breathe
  |
  \bar "||"

  %7
  f16( g16)( as8)\accent \breathe
  bes16( c16)( des8)\accent \breathe
  es16( f16)( fis8)\accent \breathe
  gis16( ais16)( b8)\accent \breathe
  |
  %8
  c16( d16)( es8)\accent \breathe
  f16( g16)( as8)\accent \breathe
  f16( g16)( as8)\accent \breathe
  c,16( d16)( es8)\accent \breathe
  |
  %9
  gis,16( ais16)( b8)\accent \breathe
  es,16( f16)( fis8)\accent \breathe
  bes,16( c16)( des8)\accent \breathe
  f,16( g16)( as8)\accent \breathe
  |
  \bar ":..:"
}

gitdOne = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %1
  \tuplet 3/2 { < f-1\6-\RH #1 >8(\accent < g-3 >)( < as-4 >) } \breathe
  \tuplet 3/2 { < bes\5 >8(\accent c)( des) } \breathe
  \tuplet 3/2 { < es\4 >8(\accent f)( fis) } \breathe
  \tuplet 3/2 { < gis\3 >8(\accent ais)( b) } \breathe
  |
  %2
  \tuplet 3/2 { < c\2 >8(\accent d)( es) } \breathe
  \tuplet 3/2 { < f\1 >8(\accent g)( as) } \breathe
  \tuplet 3/2 { < f >8(\accent g)( as) } \breathe
  \tuplet 3/2 { < c, >8(\accent d)( es) } \breathe
  |
  %3
  \tuplet 3/2 { gis,8(\accent ais)( b) } \breathe
  \tuplet 3/2 { es,8(\accent f)( fis) } \breathe
  \tuplet 3/2 { bes,8(\accent c)( des) } \breathe
  \tuplet 3/2 { f,8(\accent g)( as) } \breathe
  |
  \bar "||"

  %4
  \tuplet 3/2 { f8( g)(\accent as) } \breathe
  \tuplet 3/2 { bes8( c)(\accent des) } \breathe
  \tuplet 3/2 { es8( f)(\accent fis) } \breathe
  \tuplet 3/2 { gis8( ais)(\accent b) } \breathe
  |
}

gitdFive = \relative c' {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #5
  %5
  \tuplet 3/2 { c8( d)(\accent es) } \breathe
  \tuplet 3/2 { f8( g)(\accent as) } \breathe
  \tuplet 3/2 { f8( g)(\accent as) } \breathe
  \tuplet 3/2 { c,8( d)(\accent es) } \breathe
  |
  %6
  \tuplet 3/2 { gis,8( ais)(\accent b) } \breathe
  \tuplet 3/2 { es,8( f)(\accent fis) } \breathe
  \tuplet 3/2 { bes,8( c)(\accent des) } \breathe
  \tuplet 3/2 { f,8( g)(\accent as) } \breathe
  |
  \bar "||"

  %7
  \tuplet 3/2 { f8( g)( as)\accent } \breathe
  \tuplet 3/2 { bes8( c)( des)\accent } \breathe
  \tuplet 3/2 { es8( f)( fis)\accent } \breathe
  \tuplet 3/2 { gis8( ais)( b)\accent } \breathe
  |
  %8
  \tuplet 3/2 { c8( d)( es)\accent } \breathe
  \tuplet 3/2 { f8( g)( as)\accent } \breathe
  \tuplet 3/2 { f8( g)( as)\accent } \breathe
  \tuplet 3/2 { c,8( d)( es)\accent } \breathe
  |
  %9
  \tuplet 3/2 { gis,8( ais)( b)\accent } \breathe
  \tuplet 3/2 { es,8( f)( fis)\accent } \breathe
  \tuplet 3/2 { bes,8( c)( des)\accent } \breathe
  \tuplet 3/2 { f,8( g)( as)\accent } \breathe
  |
  \bar ":..:"
}

giteOne = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %1
  \tuplet 3/2 { < f-1\6-\RH #1 >8(\accent < g-3 >)( < as-4 >) }
  \tuplet 3/2 { < bes\5 >8(\accent c)( des) } \breathe
  \tuplet 3/2 { < es\4 >8(\accent f)( fis) }
  \tuplet 3/2 { < gis\3 >8(\accent ais)( b) } \breathe
  |
  %2
  \tuplet 3/2 { < c\2 >8(\accent d)( es) }
  \tuplet 3/2 { < f\1 >8(\accent g)( as) } \breathe
  \tuplet 3/2 { < f >8(\accent g)( as) }
  \tuplet 3/2 { < c, >8(\accent d)( es) } \breathe
  |
  %3
  \tuplet 3/2 { gis,8(\accent ais)( b) }
  \tuplet 3/2 { es,8(\accent f)( fis) } \breathe
  \tuplet 3/2 { bes,8(\accent c)( des) }
  \tuplet 3/2 { f,8(\accent g)( as) } \breathe
  |
  \bar "||"

  %4
  \tuplet 3/2 { f8( g)(\accent as) }
  \tuplet 3/2 { bes8( c)(\accent des) } \breathe
  \tuplet 3/2 { es8( f)(\accent fis) }
  \tuplet 3/2 { gis8( ais)(\accent b) } \breathe
  |
}

giteFive = \relative c' {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \override Staff.TimeSignature.stencil = ##f
  \set Score.currentBarNumber = #5
  %5
  \tuplet 3/2 { c8( d)(\accent es) }
  \tuplet 3/2 { f8( g)(\accent as) } \breathe
  \tuplet 3/2 { f8( g)(\accent as) }
  \tuplet 3/2 { c,8( d)(\accent es) } \breathe
  |
  %6
  \tuplet 3/2 { gis,8( ais)(\accent b) }
  \tuplet 3/2 { es,8( f)(\accent fis) } \breathe
  \tuplet 3/2 { bes,8( c)(\accent des) }
  \tuplet 3/2 { f,8( g)(\accent as) } \breathe
  |
  \bar "||"

  %7
  \tuplet 3/2 { f8( g)( as)\accent }
  \tuplet 3/2 { bes8( c)( des)\accent } \breathe
  \tuplet 3/2 { es8( f)( fis)\accent }
  \tuplet 3/2 { gis8( ais)( b)\accent } \breathe
  |
  %8
  \tuplet 3/2 { c8( d)( es)\accent }
  \tuplet 3/2 { f8( g)( as)\accent } \breathe
  \tuplet 3/2 { f8( g)( as)\accent }
  \tuplet 3/2 { c,8( d)( es)\accent } \breathe
  |
  %9
  \tuplet 3/2 { gis,8( ais)( b)\accent }
  \tuplet 3/2 { es,8( f)( fis)\accent } \breathe
  \tuplet 3/2 { bes,8( c)( des)\accent }
  \tuplet 3/2 { f,8( g)( as)\accent } \breathe
  |
  \bar ":..:"
}

gitf = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %1
  \tuplet 3/2 { < f-1\6-\RH #1 >8(\accent < g-3 >)( < as-4 >) }
  \tuplet 3/2 { < bes\5 >8(\accent c)( des) }
  \tuplet 3/2 { < es\4 >8(\accent f)( fis) } \breathe
  \tuplet 3/2 { < gis\3 >8(\accent ais)( b) }
  |
  %2
  \tuplet 3/2 { < c\2 >8(\accent d)( es) }
  \tuplet 3/2 { < f\1 >8(\accent g)( as) } \breathe
  \tuplet 3/2 { < f >8(\accent g)( as) }
  \tuplet 3/2 { < c, >8(\accent d)( es) }
  |
  %3
  \tuplet 3/2 { gis,8(\accent ais)( b) } \breathe
  \tuplet 3/2 { es,8(\accent f)( fis) }
  \tuplet 3/2 { bes,8(\accent c)( des) }
  \tuplet 3/2 { f,8(\accent g)( as) } \breathe
  |
  \bar "||"

  %4
  \tuplet 3/2 { f8( g)(\accent as) }
  \tuplet 3/2 { bes8( c)(\accent des) }
  \tuplet 3/2 { es8( f)(\accent fis) } \breathe
  \tuplet 3/2 { gis8( ais)(\accent b) }
  |
  %5
  \tuplet 3/2 { c8( d)(\accent es) }
  \tuplet 3/2 { f8( g)(\accent as) } \breathe
  \tuplet 3/2 { f8( g)(\accent as) }
  \tuplet 3/2 { c,8( d)(\accent es) }
  |
  %6
  \tuplet 3/2 { gis,8( ais)(\accent b) } \breathe
  \tuplet 3/2 { es,8( f)(\accent fis) }
  \tuplet 3/2 { bes,8( c)(\accent des) }
  \tuplet 3/2 { f,8( g)(\accent as) } \breathe
  |
  \bar "||"

  %7
  \tuplet 3/2 { f8( g)( as)\accent }
  \tuplet 3/2 { bes8( c)( des)\accent }
  \tuplet 3/2 { es8( f)( fis)\accent } \breathe
  \tuplet 3/2 { gis8( ais)( b)\accent }
  |
  %8
  \tuplet 3/2 { c8( d)( es)\accent }
  \tuplet 3/2 { f8( g)( as)\accent } \breathe
  \tuplet 3/2 { f8( g)( as)\accent }
  \tuplet 3/2 { c,8( d)( es)\accent }
  |
  %9
  \tuplet 3/2 { gis,8( ais)( b)\accent } \breathe
  \tuplet 3/2 { es,8( f)( fis)\accent }
  \tuplet 3/2 { bes,8( c)( des)\accent }
  \tuplet 3/2 { f,8( g)( as)\accent } \breathe
  |
  \bar ":..:"
}

gitg = \relative c, {
  \key c \major
  \time 4/4
  \clef "treble_8"

  \override StrokeFinger.avoid-slur = #'outside
  \fDL
  \bar ":..:"
  %1
  \tuplet 3/2 { < f-1\6-\RH #1 >8(\accent < g-3 >)( < as-4 >) }
  \tuplet 3/2 { < bes\5 >8(\accent c)( des) }
  \tuplet 3/2 { < es\4 >8(\accent f)( fis) }
  \tuplet 3/2 { < gis\3 >8(\accent ais)( b) }
  |
  %2
  \tuplet 3/2 { < c\2 >8(\accent d)( es) }
  \tuplet 3/2 { < f\1 >8(\accent g)( as) } \breathe
  \tuplet 3/2 { < f >8(\accent g)( as) }
  \tuplet 3/2 { < c, >8(\accent d)( es) }
  |
  %3
  \tuplet 3/2 { gis,8(\accent ais)( b) }
  \tuplet 3/2 { es,8(\accent f)( fis) }
  \tuplet 3/2 { bes,8(\accent c)( des) }
  \tuplet 3/2 { f,8(\accent g)( as) } \breathe
  |
  \bar "||"

  %4
  \tuplet 3/2 { f8( g)(\accent as) }
  \tuplet 3/2 { bes8( c)(\accent des) }
  \tuplet 3/2 { es8( f)(\accent fis) }
  \tuplet 3/2 { gis8( ais)(\accent b) }
  |
  %5
  \tuplet 3/2 { c8( d)(\accent es) }
  \tuplet 3/2 { f8( g)(\accent as) } \breathe
  \tuplet 3/2 { f8( g)(\accent as) }
  \tuplet 3/2 { c,8( d)(\accent es) }
  |
  %6
  \tuplet 3/2 { gis,8( ais)(\accent b) }
  \tuplet 3/2 { es,8( f)(\accent fis) }
  \tuplet 3/2 { bes,8( c)(\accent des) }
  \tuplet 3/2 { f,8( g)(\accent as) } \breathe
  |
  \bar "||"

  %7
  \tuplet 3/2 { f8( g)( as)\accent }
  \tuplet 3/2 { bes8( c)( des)\accent }
  \tuplet 3/2 { es8( f)( fis)\accent }
  \tuplet 3/2 { gis8( ais)( b)\accent }
  |
  %8
  \tuplet 3/2 { c8( d)( es)\accent }
  \tuplet 3/2 { f8( g)( as)\accent } \breathe
  \tuplet 3/2 { f8( g)( as)\accent }
  \tuplet 3/2 { c,8( d)( es)\accent }
  |
  %9
  \tuplet 3/2 { gis,8( ais)( b)\accent }
  \tuplet 3/2 { es,8( f)( fis)\accent }
  \tuplet 3/2 { bes,8( c)( des)\accent }
  \tuplet 3/2 { f,8( g)( as)\accent } \breathe
  |
  \bar ":..:"
}


% \book {
%   \score {
%     {
%       \gita
%       \break
%       \gitb
%       \break
%       \gitc
%       \break
%       \gitd
%       \break
%       \gite
%       \break
%       \gitf
%       \break
%       \gitg
%     }
%   }
% }

#(define output-suffix "1")
\book {
  \score {
    \gita
  }
}

#(define output-suffix "2")
\book {
  \score {
    \gitb
  }
}

#(define output-suffix "3a")
\book {
  \score {
    \gitcOne
  }
}

#(define output-suffix "3b")
\book {
  \paper { indent = 0.0 }

  \score {
    \gitcFive
  }
}

#(define output-suffix "4a")
\book {
  \score {
    \gitdOne
  }
}

#(define output-suffix "4b")
\book {
  \paper { indent = 0.0 }

  \score {
    \gitdFive
  }
}

#(define output-suffix "5a")
\book {
  \score {
    \giteOne
  }
}

#(define output-suffix "5b")
\book {
  \paper { indent = 0.0 }

  \score {
    \giteFive
  }
}

#(define output-suffix "6")
\book {
  \score {
    \gitf
  }
}

#(define output-suffix "7")
\book {
  \score {
    \gitg
  }
}
